// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.model



public class GetPropertyValueRequest private constructor(builder: Builder) {
    /**
     * The name of the component whose property values the operation returns.
     */
    public val componentName: kotlin.String? = builder.componentName
    /**
     * The ID of the component type whose property values the operation returns.
     */
    public val componentTypeId: kotlin.String? = builder.componentTypeId
    /**
     * The ID of the entity whose property values the operation returns.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The maximum number of results to return at one time. The default is 25.
     *
     * Valid Range: Minimum value of 1. Maximum value of 250.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The string that specifies the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The property group name.
     */
    public val propertyGroupName: kotlin.String? = builder.propertyGroupName
    /**
     * The properties whose values the operation returns.
     */
    public val selectedProperties: List<String>? = builder.selectedProperties
    /**
     * The tabular conditions.
     */
    public val tabularConditions: aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions? = builder.tabularConditions
    /**
     * The ID of the workspace whose values the operation returns.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPropertyValueRequest(")
        append("componentName=$componentName,")
        append("componentTypeId=$componentTypeId,")
        append("entityId=$entityId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("propertyGroupName=$propertyGroupName,")
        append("selectedProperties=$selectedProperties,")
        append("tabularConditions=$tabularConditions,")
        append("workspaceId=$workspaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentName?.hashCode() ?: 0
        result = 31 * result + (componentTypeId?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (propertyGroupName?.hashCode() ?: 0)
        result = 31 * result + (selectedProperties?.hashCode() ?: 0)
        result = 31 * result + (tabularConditions?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPropertyValueRequest

        if (componentName != other.componentName) return false
        if (componentTypeId != other.componentTypeId) return false
        if (entityId != other.entityId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (propertyGroupName != other.propertyGroupName) return false
        if (selectedProperties != other.selectedProperties) return false
        if (tabularConditions != other.tabularConditions) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the component whose property values the operation returns.
         */
        public var componentName: kotlin.String? = null
        /**
         * The ID of the component type whose property values the operation returns.
         */
        public var componentTypeId: kotlin.String? = null
        /**
         * The ID of the entity whose property values the operation returns.
         */
        public var entityId: kotlin.String? = null
        /**
         * The maximum number of results to return at one time. The default is 25.
         *
         * Valid Range: Minimum value of 1. Maximum value of 250.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The string that specifies the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The property group name.
         */
        public var propertyGroupName: kotlin.String? = null
        /**
         * The properties whose values the operation returns.
         */
        public var selectedProperties: List<String>? = null
        /**
         * The tabular conditions.
         */
        public var tabularConditions: aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions? = null
        /**
         * The ID of the workspace whose values the operation returns.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest) : this() {
            this.componentName = x.componentName
            this.componentTypeId = x.componentTypeId
            this.entityId = x.entityId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.propertyGroupName = x.propertyGroupName
            this.selectedProperties = x.selectedProperties
            this.tabularConditions = x.tabularConditions
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest = GetPropertyValueRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions] inside the given [block]
         */
        public fun tabularConditions(block: aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions.Builder.() -> kotlin.Unit) {
            this.tabularConditions = aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions.invoke(block)
        }
    }
}
