// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.model



public class ListEntitiesRequest private constructor(builder: Builder) {
    /**
     * A list of objects that filter the request.
     *
     * Only one object is accepted as a valid input.
     */
    public val filters: List<ListEntitiesFilter>? = builder.filters
    /**
     * The maximum number of results to return at one time. The default is 25.
     *
     * Valid Range: Minimum value of 1. Maximum value of 250.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The string that specifies the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the workspace.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListEntitiesRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("workspaceId=$workspaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListEntitiesRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of objects that filter the request.
         *
         * Only one object is accepted as a valid input.
         */
        public var filters: List<ListEntitiesFilter>? = null
        /**
         * The maximum number of results to return at one time. The default is 25.
         *
         * Valid Range: Minimum value of 1. Maximum value of 250.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The string that specifies the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID of the workspace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest = ListEntitiesRequest(this)
    }
}
