// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.model



public class UpdateComponentTypeRequest private constructor(builder: Builder) {
    /**
     * The ID of the component type.
     */
    public val componentTypeId: kotlin.String? = requireNotNull(builder.componentTypeId) { "A non-null value must be provided for componentTypeId" }
    /**
     * The description of the component type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the component type that this component type extends.
     */
    public val extendsFrom: List<String>? = builder.extendsFrom
    /**
     * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.
     */
    public val functions: Map<String, FunctionRequest>? = builder.functions
    /**
     * A Boolean value that specifies whether an entity can have more than one component of this type.
     */
    public val isSingleton: kotlin.Boolean? = builder.isSingleton
    /**
     * An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.
     */
    public val propertyDefinitions: Map<String, PropertyDefinitionRequest>? = builder.propertyDefinitions
    /**
     * The property groups
     */
    public val propertyGroups: Map<String, PropertyGroupRequest>? = builder.propertyGroups
    /**
     * The ID of the workspace that contains the component type.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateComponentTypeRequest(")
        append("componentTypeId=$componentTypeId,")
        append("description=$description,")
        append("extendsFrom=$extendsFrom,")
        append("functions=$functions,")
        append("isSingleton=$isSingleton,")
        append("propertyDefinitions=$propertyDefinitions,")
        append("propertyGroups=$propertyGroups,")
        append("workspaceId=$workspaceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = componentTypeId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (extendsFrom?.hashCode() ?: 0)
        result = 31 * result + (functions?.hashCode() ?: 0)
        result = 31 * result + (isSingleton?.hashCode() ?: 0)
        result = 31 * result + (propertyDefinitions?.hashCode() ?: 0)
        result = 31 * result + (propertyGroups?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateComponentTypeRequest

        if (componentTypeId != other.componentTypeId) return false
        if (description != other.description) return false
        if (extendsFrom != other.extendsFrom) return false
        if (functions != other.functions) return false
        if (isSingleton != other.isSingleton) return false
        if (propertyDefinitions != other.propertyDefinitions) return false
        if (propertyGroups != other.propertyGroups) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the component type.
         */
        public var componentTypeId: kotlin.String? = null
        /**
         * The description of the component type.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the component type that this component type extends.
         */
        public var extendsFrom: List<String>? = null
        /**
         * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.
         */
        public var functions: Map<String, FunctionRequest>? = null
        /**
         * A Boolean value that specifies whether an entity can have more than one component of this type.
         */
        public var isSingleton: kotlin.Boolean? = null
        /**
         * An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.
         */
        public var propertyDefinitions: Map<String, PropertyDefinitionRequest>? = null
        /**
         * The property groups
         */
        public var propertyGroups: Map<String, PropertyGroupRequest>? = null
        /**
         * The ID of the workspace that contains the component type.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeRequest) : this() {
            this.componentTypeId = x.componentTypeId
            this.description = x.description
            this.extendsFrom = x.extendsFrom
            this.functions = x.functions
            this.isSingleton = x.isSingleton
            this.propertyDefinitions = x.propertyDefinitions
            this.propertyGroups = x.propertyGroups
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeRequest = UpdateComponentTypeRequest(this)
    }
}
