// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.paginators

import aws.sdk.kotlin.services.iottwinmaker.IoTTwinMakerClient
import aws.sdk.kotlin.services.iottwinmaker.model.ExecuteQueryRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ExecuteQueryResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueHistoryRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueHistoryResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListComponentTypesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListComponentTypesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListScenesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListScenesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListWorkspacesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ExecuteQueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ExecuteQueryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExecuteQueryResponse]
 */
public fun IoTTwinMakerClient.executeQueryPaginated(initialRequest: ExecuteQueryRequest): Flow<ExecuteQueryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@executeQueryPaginated.executeQuery(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ExecuteQueryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExecuteQueryResponse]
 */
public fun IoTTwinMakerClient.executeQueryPaginated(block: ExecuteQueryRequest.Builder.() -> Unit): Flow<ExecuteQueryResponse> =
    executeQueryPaginated(ExecuteQueryRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPropertyValueResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPropertyValueRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPropertyValueResponse]
 */
public fun IoTTwinMakerClient.getPropertyValuePaginated(initialRequest: GetPropertyValueRequest): Flow<GetPropertyValueResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPropertyValuePaginated.getPropertyValue(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetPropertyValueResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPropertyValueResponse]
 */
public fun IoTTwinMakerClient.getPropertyValuePaginated(block: GetPropertyValueRequest.Builder.() -> Unit): Flow<GetPropertyValueResponse> =
    getPropertyValuePaginated(GetPropertyValueRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPropertyValueHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPropertyValueHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPropertyValueHistoryResponse]
 */
public fun IoTTwinMakerClient.getPropertyValueHistoryPaginated(initialRequest: GetPropertyValueHistoryRequest): Flow<GetPropertyValueHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPropertyValueHistoryPaginated.getPropertyValueHistory(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetPropertyValueHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPropertyValueHistoryResponse]
 */
public fun IoTTwinMakerClient.getPropertyValueHistoryPaginated(block: GetPropertyValueHistoryRequest.Builder.() -> Unit): Flow<GetPropertyValueHistoryResponse> =
    getPropertyValueHistoryPaginated(GetPropertyValueHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListComponentTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComponentTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentTypesResponse]
 */
public fun IoTTwinMakerClient.listComponentTypesPaginated(initialRequest: ListComponentTypesRequest): Flow<ListComponentTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComponentTypesPaginated.listComponentTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListComponentTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComponentTypesResponse]
 */
public fun IoTTwinMakerClient.listComponentTypesPaginated(block: ListComponentTypesRequest.Builder.() -> Unit): Flow<ListComponentTypesResponse> =
    listComponentTypesPaginated(ListComponentTypesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesResponse]
 */
public fun IoTTwinMakerClient.listEntitiesPaginated(initialRequest: ListEntitiesRequest): Flow<ListEntitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntitiesPaginated.listEntities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntitiesResponse]
 */
public fun IoTTwinMakerClient.listEntitiesPaginated(block: ListEntitiesRequest.Builder.() -> Unit): Flow<ListEntitiesResponse> =
    listEntitiesPaginated(ListEntitiesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListScenesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScenesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScenesResponse]
 */
public fun IoTTwinMakerClient.listScenesPaginated(initialRequest: ListScenesRequest): Flow<ListScenesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScenesPaginated.listScenes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListScenesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScenesResponse]
 */
public fun IoTTwinMakerClient.listScenesPaginated(block: ListScenesRequest.Builder.() -> Unit): Flow<ListScenesResponse> =
    listScenesPaginated(ListScenesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkspacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun IoTTwinMakerClient.listWorkspacesPaginated(initialRequest: ListWorkspacesRequest): Flow<ListWorkspacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkspacesPaginated.listWorkspaces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun IoTTwinMakerClient.listWorkspacesPaginated(block: ListWorkspacesRequest.Builder.() -> Unit): Flow<ListWorkspacesResponse> =
    listWorkspacesPaginated(ListWorkspacesRequest.Builder().apply(block).build())
