// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.CreateComponentTypeRequest
import aws.sdk.kotlin.services.iottwinmaker.model.FunctionRequest
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyDefinitionRequest
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyGroupRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateComponentTypeOperationSerializer: HttpSerialize<CreateComponentTypeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateComponentTypeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "component-types",
                "${input.componentTypeId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateComponentTypeOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateComponentTypeOperationBody(context: ExecutionContext, input: CreateComponentTypeRequest): ByteArray {
    val serializer = JsonSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTENDSFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("extendsFrom"))
    val FUNCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("functions"))
    val ISSINGLETON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isSingleton"))
    val PROPERTYDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("propertyDefinitions"))
    val PROPERTYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("propertyGroups"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTENDSFROM_DESCRIPTOR)
        field(FUNCTIONS_DESCRIPTOR)
        field(ISSINGLETON_DESCRIPTOR)
        field(PROPERTYDEFINITIONS_DESCRIPTOR)
        field(PROPERTYGROUPS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.extendsFrom != null) {
            listField(EXTENDSFROM_DESCRIPTOR) {
                for (el0 in input.extendsFrom) {
                    serializeString(el0)
                }
            }
        }
        if (input.functions != null) {
            mapField(FUNCTIONS_DESCRIPTOR) {
                input.functions.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeFunctionRequestDocument)) }
            }
        }
        input.isSingleton?.let { field(ISSINGLETON_DESCRIPTOR, it) }
        if (input.propertyDefinitions != null) {
            mapField(PROPERTYDEFINITIONS_DESCRIPTOR) {
                input.propertyDefinitions.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePropertyDefinitionRequestDocument)) }
            }
        }
        if (input.propertyGroups != null) {
            mapField(PROPERTYGROUPS_DESCRIPTOR) {
                input.propertyGroups.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePropertyGroupRequestDocument)) }
            }
        }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
