// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.ComponentRequest
import aws.sdk.kotlin.services.iottwinmaker.model.CreateEntityRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateEntityOperationSerializer: HttpSerialize<CreateEntityRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateEntityRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "entities",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateEntityOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateEntityOperationBody(context: ExecutionContext, input: CreateEntityRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPONENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("components"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val ENTITYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityName"))
    val PARENTENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentEntityId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ENTITYNAME_DESCRIPTOR)
        field(PARENTENTITYID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.components != null) {
            mapField(COMPONENTS_DESCRIPTOR) {
                input.components.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeComponentRequestDocument)) }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.entityId?.let { field(ENTITYID_DESCRIPTOR, it) }
        input.entityName?.let { field(ENTITYNAME_DESCRIPTOR, it) }
        input.parentEntityId?.let { field(PARENTENTITYID_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
