// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iottwinmaker.model.ColumnDescription
import aws.sdk.kotlin.services.iottwinmaker.model.ExecuteQueryResponse
import aws.sdk.kotlin.services.iottwinmaker.model.IoTTwinMakerException
import aws.sdk.kotlin.services.iottwinmaker.model.Row
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ExecuteQueryOperationDeserializer: HttpDeserialize<ExecuteQueryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ExecuteQueryResponse {
        if (!response.status.isSuccess()) {
            throwExecuteQueryError(context, response)
        }
        val builder = ExecuteQueryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteQueryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwExecuteQueryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTTwinMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "QueryTimeoutException" -> QueryTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTTwinMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExecuteQueryOperationBody(builder: ExecuteQueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLUMNDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("columnDescriptions"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val ROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rows"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNDESCRIPTIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(ROWS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLUMNDESCRIPTIONS_DESCRIPTOR.index -> builder.columnDescriptions =
                    deserializer.deserializeList(COLUMNDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ColumnDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeColumnDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                ROWS_DESCRIPTOR.index -> builder.rows =
                    deserializer.deserializeList(ROWS_DESCRIPTOR) {
                        val col0 = mutableListOf<Row>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRowDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
