// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iottwinmaker.model.FunctionResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetComponentTypeResponse
import aws.sdk.kotlin.services.iottwinmaker.model.IoTTwinMakerException
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyDefinitionResponse
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyGroupResponse
import aws.sdk.kotlin.services.iottwinmaker.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetComponentTypeOperationDeserializer: HttpDeserialize<GetComponentTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetComponentTypeResponse {
        if (!response.status.isSuccess()) {
            throwGetComponentTypeError(context, response)
        }
        val builder = GetComponentTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetComponentTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetComponentTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTTwinMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTTwinMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetComponentTypeOperationBody(builder: GetComponentTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val COMPONENTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("componentTypeId"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val EXTENDSFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("extendsFrom"))
    val FUNCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("functions"))
    val ISABSTRACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isAbstract"))
    val ISSCHEMAINITIALIZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isSchemaInitialized"))
    val ISSINGLETON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isSingleton"))
    val PROPERTYDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("propertyDefinitions"))
    val PROPERTYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("propertyGroups"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val UPDATEDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDateTime"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COMPONENTTYPEID_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXTENDSFROM_DESCRIPTOR)
        field(FUNCTIONS_DESCRIPTOR)
        field(ISABSTRACT_DESCRIPTOR)
        field(ISSCHEMAINITIALIZED_DESCRIPTOR)
        field(ISSINGLETON_DESCRIPTOR)
        field(PROPERTYDEFINITIONS_DESCRIPTOR)
        field(PROPERTYGROUPS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDATETIME_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COMPONENTTYPEID_DESCRIPTOR.index -> builder.componentTypeId = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                EXTENDSFROM_DESCRIPTOR.index -> builder.extendsFrom =
                    deserializer.deserializeList(EXTENDSFROM_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FUNCTIONS_DESCRIPTOR.index -> builder.functions =
                    deserializer.deserializeMap(FUNCTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, FunctionResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeFunctionResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ISABSTRACT_DESCRIPTOR.index -> builder.isAbstract = deserializeBoolean()
                ISSCHEMAINITIALIZED_DESCRIPTOR.index -> builder.isSchemaInitialized = deserializeBoolean()
                ISSINGLETON_DESCRIPTOR.index -> builder.isSingleton = deserializeBoolean()
                PROPERTYDEFINITIONS_DESCRIPTOR.index -> builder.propertyDefinitions =
                    deserializer.deserializeMap(PROPERTYDEFINITIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, PropertyDefinitionResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializePropertyDefinitionResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                PROPERTYGROUPS_DESCRIPTOR.index -> builder.propertyGroups =
                    deserializer.deserializeMap(PROPERTYGROUPS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, PropertyGroupResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializePropertyGroupResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeStatusDocument(deserializer)
                UPDATEDATETIME_DESCRIPTOR.index -> builder.updateDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
