// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iottwinmaker.model.ComponentResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetEntityResponse
import aws.sdk.kotlin.services.iottwinmaker.model.IoTTwinMakerException
import aws.sdk.kotlin.services.iottwinmaker.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetEntityOperationDeserializer: HttpDeserialize<GetEntityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEntityResponse {
        if (!response.status.isSuccess()) {
            throwGetEntityError(context, response)
        }
        val builder = GetEntityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEntityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEntityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTTwinMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTTwinMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEntityOperationBody(builder: GetEntityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val COMPONENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("components"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val ENTITYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityName"))
    val HASCHILDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("hasChildEntities"))
    val PARENTENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentEntityId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val UPDATEDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDateTime"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COMPONENTS_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ENTITYNAME_DESCRIPTOR)
        field(HASCHILDENTITIES_DESCRIPTOR)
        field(PARENTENTITYID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDATETIME_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COMPONENTS_DESCRIPTOR.index -> builder.components =
                    deserializer.deserializeMap(COMPONENTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ComponentResponse>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeComponentResponseDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENTITYID_DESCRIPTOR.index -> builder.entityId = deserializeString()
                ENTITYNAME_DESCRIPTOR.index -> builder.entityName = deserializeString()
                HASCHILDENTITIES_DESCRIPTOR.index -> builder.hasChildEntities = deserializeBoolean()
                PARENTENTITYID_DESCRIPTOR.index -> builder.parentEntityId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeStatusDocument(deserializer)
                UPDATEDATETIME_DESCRIPTOR.index -> builder.updateDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
