// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueHistoryRequest
import aws.sdk.kotlin.services.iottwinmaker.model.InterpolationParameters
import aws.sdk.kotlin.services.iottwinmaker.model.OrderByTime
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyFilter
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetPropertyValueHistoryOperationSerializer: HttpSerialize<GetPropertyValueHistoryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetPropertyValueHistoryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "entity-properties",
                "history",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetPropertyValueHistoryOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetPropertyValueHistoryOperationBody(context: ExecutionContext, input: GetPropertyValueHistoryRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPONENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("componentName"))
    val COMPONENTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("componentTypeId"))
    val ENDDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endDateTime"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("endTime"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val INTERPOLATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("interpolation"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val ORDERBYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("orderByTime"))
    val PROPERTYFILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("propertyFilters"))
    val SELECTEDPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("selectedProperties"))
    val STARTDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startDateTime"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("startTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTNAME_DESCRIPTOR)
        field(COMPONENTTYPEID_DESCRIPTOR)
        field(ENDDATETIME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(INTERPOLATION_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(ORDERBYTIME_DESCRIPTOR)
        field(PROPERTYFILTERS_DESCRIPTOR)
        field(SELECTEDPROPERTIES_DESCRIPTOR)
        field(STARTDATETIME_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.componentName?.let { field(COMPONENTNAME_DESCRIPTOR, it) }
        input.componentTypeId?.let { field(COMPONENTTYPEID_DESCRIPTOR, it) }
        input.endDateTime?.let { field(ENDDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.endTime?.let { field(ENDTIME_DESCRIPTOR, it) }
        input.entityId?.let { field(ENTITYID_DESCRIPTOR, it) }
        input.interpolation?.let { field(INTERPOLATION_DESCRIPTOR, it, ::serializeInterpolationParametersDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.orderByTime?.let { field(ORDERBYTIME_DESCRIPTOR, it.value) }
        if (input.propertyFilters != null) {
            listField(PROPERTYFILTERS_DESCRIPTOR) {
                for (el0 in input.propertyFilters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePropertyFilterDocument))
                }
            }
        }
        if (input.selectedProperties != null) {
            listField(SELECTEDPROPERTIES_DESCRIPTOR) {
                for (el0 in input.selectedProperties) {
                    serializeString(el0)
                }
            }
        }
        input.startDateTime?.let { field(STARTDATETIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.startTime?.let { field(STARTTIME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
