// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iottwinmaker.model.DataValue
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueResponse
import aws.sdk.kotlin.services.iottwinmaker.model.IoTTwinMakerException
import aws.sdk.kotlin.services.iottwinmaker.model.PropertyLatestValue
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetPropertyValueOperationDeserializer: HttpDeserialize<GetPropertyValueResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPropertyValueResponse {
        if (!response.status.isSuccess()) {
            throwGetPropertyValueError(context, response)
        }
        val builder = GetPropertyValueResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPropertyValueOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPropertyValueError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTTwinMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConnectorFailureException" -> ConnectorFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConnectorTimeoutException" -> ConnectorTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTTwinMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPropertyValueOperationBody(builder: GetPropertyValueResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PROPERTYVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("propertyValues"))
    val TABULARPROPERTYVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tabularPropertyValues"))
    val TABULARPROPERTYVALUES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val TABULARPROPERTYVALUES_C1_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PROPERTYVALUES_DESCRIPTOR)
        field(TABULARPROPERTYVALUES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PROPERTYVALUES_DESCRIPTOR.index -> builder.propertyValues =
                    deserializer.deserializeMap(PROPERTYVALUES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, PropertyLatestValue>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializePropertyLatestValueDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TABULARPROPERTYVALUES_DESCRIPTOR.index -> builder.tabularPropertyValues =
                    deserializer.deserializeList(TABULARPROPERTYVALUES_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Map<String, DataValue>>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(TABULARPROPERTYVALUES_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Map<String, DataValue>>()
                                while (hasNextElement()) {
                                    val el1 = deserializer.deserializeMap(TABULARPROPERTYVALUES_C1_DESCRIPTOR) {
                                        val map2 = mutableMapOf<String, DataValue>()
                                        while (hasNextEntry()) {
                                            val k2 = key()
                                            val v2 = if (nextHasValue()) { deserializeDataValueDocument(deserializer) } else { deserializeNull(); continue }
                                            map2[k2] = v2
                                        }
                                        map2
                                    }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
