// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest
import aws.sdk.kotlin.services.iottwinmaker.model.TabularConditions
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPropertyValueOperationSerializer: HttpSerialize<GetPropertyValueRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetPropertyValueRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "entity-properties",
                "value",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGetPropertyValueOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGetPropertyValueOperationBody(context: ExecutionContext, input: GetPropertyValueRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPONENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("componentName"))
    val COMPONENTTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("componentTypeId"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PROPERTYGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("propertyGroupName"))
    val SELECTEDPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("selectedProperties"))
    val TABULARCONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tabularConditions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTNAME_DESCRIPTOR)
        field(COMPONENTTYPEID_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PROPERTYGROUPNAME_DESCRIPTOR)
        field(SELECTEDPROPERTIES_DESCRIPTOR)
        field(TABULARCONDITIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.componentName?.let { field(COMPONENTNAME_DESCRIPTOR, it) }
        input.componentTypeId?.let { field(COMPONENTTYPEID_DESCRIPTOR, it) }
        input.entityId?.let { field(ENTITYID_DESCRIPTOR, it) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.propertyGroupName?.let { field(PROPERTYGROUPNAME_DESCRIPTOR, it) }
        if (input.selectedProperties != null) {
            listField(SELECTEDPROPERTIES_DESCRIPTOR) {
                for (el0 in input.selectedProperties) {
                    serializeString(el0)
                }
            }
        }
        input.tabularConditions?.let { field(TABULARCONDITIONS_DESCRIPTOR, it, ::serializeTabularConditionsDocument) }
    }
    return serializer.toByteArray()
}
