// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iottwinmaker.model.GetWorkspaceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.IoTTwinMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetWorkspaceOperationDeserializer: HttpDeserialize<GetWorkspaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWorkspaceResponse {
        if (!response.status.isSuccess()) {
            throwGetWorkspaceError(context, response)
        }
        val builder = GetWorkspaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkspaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWorkspaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTTwinMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTTwinMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkspaceOperationBody(builder: GetWorkspaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATIONDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationDateTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("role"))
    val S3LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("s3Location"))
    val UPDATEDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateDateTime"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONDATETIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(S3LOCATION_DESCRIPTOR)
        field(UPDATEDATETIME_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONDATETIME_DESCRIPTOR.index -> builder.creationDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ROLE_DESCRIPTOR.index -> builder.role = deserializeString()
                S3LOCATION_DESCRIPTOR.index -> builder.s3Location = deserializeString()
                UPDATEDATETIME_DESCRIPTOR.index -> builder.updateDateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
