// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.ComponentUpdateRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ParentEntityUpdateRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateEntityRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateEntityOperationSerializer: HttpSerialize<UpdateEntityRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateEntityRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "entities",
                "${input.entityId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateEntityOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateEntityOperationBody(context: ExecutionContext, input: UpdateEntityRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPONENTUPDATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("componentUpdates"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENTITYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityName"))
    val PARENTENTITYUPDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("parentEntityUpdate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPONENTUPDATES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENTITYNAME_DESCRIPTOR)
        field(PARENTENTITYUPDATE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.componentUpdates != null) {
            mapField(COMPONENTUPDATES_DESCRIPTOR) {
                input.componentUpdates.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeComponentUpdateRequestDocument)) }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.entityName?.let { field(ENTITYNAME_DESCRIPTOR, it) }
        input.parentEntityUpdate?.let { field(PARENTENTITYUPDATE_DESCRIPTOR, it, ::serializeParentEntityUpdateRequestDocument) }
    }
    return serializer.toByteArray()
}
