// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker.transform

import aws.sdk.kotlin.services.iottwinmaker.model.UpdateSceneRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSceneOperationSerializer: HttpSerialize<UpdateSceneRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateSceneRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "workspaces",
                "${input.workspaceId}".encodeLabel(),
                "scenes",
                "${input.sceneId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateSceneOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSceneOperationBody(context: ExecutionContext, input: UpdateSceneRequest): ByteArray {
    val serializer = JsonSerializer()
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("capabilities"))
    val CONTENTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentLocation"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITIES_DESCRIPTOR)
        field(CONTENTLOCATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0)
                }
            }
        }
        input.contentLocation?.let { field(CONTENTLOCATION_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
