// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotwireless.model.*
import aws.sdk.kotlin.services.iotwireless.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoT Wireless"
const val ServiceApiVersion: String = "2020-11-22"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultIotWirelessClient(override val config: IotWirelessClient.Config) : IotWirelessClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a partner account with your AWS account.
     */
    override suspend fun associateAwsAccountWithPartnerAccount(input: AssociateAwsAccountWithPartnerAccountRequest): AssociateAwsAccountWithPartnerAccountResponse {
        val op = SdkHttpOperation.build<AssociateAwsAccountWithPartnerAccountRequest, AssociateAwsAccountWithPartnerAccountResponse> {
            serializer = AssociateAwsAccountWithPartnerAccountOperationSerializer()
            deserializer = AssociateAwsAccountWithPartnerAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAwsAccountWithPartnerAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associate a multicast group with a FUOTA task.
     */
    override suspend fun associateMulticastGroupWithFuotaTask(input: AssociateMulticastGroupWithFuotaTaskRequest): AssociateMulticastGroupWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateMulticastGroupWithFuotaTaskRequest, AssociateMulticastGroupWithFuotaTaskResponse> {
            serializer = AssociateMulticastGroupWithFuotaTaskOperationSerializer()
            deserializer = AssociateMulticastGroupWithFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AssociateMulticastGroupWithFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associate a wireless device with a FUOTA task.
     */
    override suspend fun associateWirelessDeviceWithFuotaTask(input: AssociateWirelessDeviceWithFuotaTaskRequest): AssociateWirelessDeviceWithFuotaTaskResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithFuotaTaskRequest, AssociateWirelessDeviceWithFuotaTaskResponse> {
            serializer = AssociateWirelessDeviceWithFuotaTaskOperationSerializer()
            deserializer = AssociateWirelessDeviceWithFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AssociateWirelessDeviceWithFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a multicast group.
     */
    override suspend fun associateWirelessDeviceWithMulticastGroup(input: AssociateWirelessDeviceWithMulticastGroupRequest): AssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithMulticastGroupRequest, AssociateWirelessDeviceWithMulticastGroupResponse> {
            serializer = AssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializer = AssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AssociateWirelessDeviceWithMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless device with a thing.
     */
    override suspend fun associateWirelessDeviceWithThing(input: AssociateWirelessDeviceWithThingRequest): AssociateWirelessDeviceWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessDeviceWithThingRequest, AssociateWirelessDeviceWithThingResponse> {
            serializer = AssociateWirelessDeviceWithThingOperationSerializer()
            deserializer = AssociateWirelessDeviceWithThingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AssociateWirelessDeviceWithThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a certificate.
     */
    override suspend fun associateWirelessGatewayWithCertificate(input: AssociateWirelessGatewayWithCertificateRequest): AssociateWirelessGatewayWithCertificateResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithCertificateRequest, AssociateWirelessGatewayWithCertificateResponse> {
            serializer = AssociateWirelessGatewayWithCertificateOperationSerializer()
            deserializer = AssociateWirelessGatewayWithCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateWirelessGatewayWithCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a wireless gateway with a thing.
     */
    override suspend fun associateWirelessGatewayWithThing(input: AssociateWirelessGatewayWithThingRequest): AssociateWirelessGatewayWithThingResponse {
        val op = SdkHttpOperation.build<AssociateWirelessGatewayWithThingRequest, AssociateWirelessGatewayWithThingResponse> {
            serializer = AssociateWirelessGatewayWithThingOperationSerializer()
            deserializer = AssociateWirelessGatewayWithThingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "AssociateWirelessGatewayWithThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an existing multicast group session.
     */
    override suspend fun cancelMulticastGroupSession(input: CancelMulticastGroupSessionRequest): CancelMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<CancelMulticastGroupSessionRequest, CancelMulticastGroupSessionResponse> {
            serializer = CancelMulticastGroupSessionOperationSerializer()
            deserializer = CancelMulticastGroupSessionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "CancelMulticastGroupSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    override suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse {
        val op = SdkHttpOperation.build<CreateDestinationRequest, CreateDestinationResponse> {
            serializer = CreateDestinationOperationSerializer()
            deserializer = CreateDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new device profile.
     */
    override suspend fun createDeviceProfile(input: CreateDeviceProfileRequest): CreateDeviceProfileResponse {
        val op = SdkHttpOperation.build<CreateDeviceProfileRequest, CreateDeviceProfileResponse> {
            serializer = CreateDeviceProfileOperationSerializer()
            deserializer = CreateDeviceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateDeviceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a FUOTA task.
     */
    override suspend fun createFuotaTask(input: CreateFuotaTaskRequest): CreateFuotaTaskResponse {
        val op = SdkHttpOperation.build<CreateFuotaTaskRequest, CreateFuotaTaskResponse> {
            serializer = CreateFuotaTaskOperationSerializer()
            deserializer = CreateFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a multicast group.
     */
    override suspend fun createMulticastGroup(input: CreateMulticastGroupRequest): CreateMulticastGroupResponse {
        val op = SdkHttpOperation.build<CreateMulticastGroupRequest, CreateMulticastGroupResponse> {
            serializer = CreateMulticastGroupOperationSerializer()
            deserializer = CreateMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new network analyzer configuration.
     */
    override suspend fun createNetworkAnalyzerConfiguration(input: CreateNetworkAnalyzerConfigurationRequest): CreateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<CreateNetworkAnalyzerConfigurationRequest, CreateNetworkAnalyzerConfigurationResponse> {
            serializer = CreateNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = CreateNetworkAnalyzerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateNetworkAnalyzerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new service profile.
     */
    override suspend fun createServiceProfile(input: CreateServiceProfileRequest): CreateServiceProfileResponse {
        val op = SdkHttpOperation.build<CreateServiceProfileRequest, CreateServiceProfileResponse> {
            serializer = CreateServiceProfileOperationSerializer()
            deserializer = CreateServiceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateServiceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless device.
     */
    override suspend fun createWirelessDevice(input: CreateWirelessDeviceRequest): CreateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<CreateWirelessDeviceRequest, CreateWirelessDeviceResponse> {
            serializer = CreateWirelessDeviceOperationSerializer()
            deserializer = CreateWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provisions a wireless gateway.
     */
    override suspend fun createWirelessGateway(input: CreateWirelessGatewayRequest): CreateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayRequest, CreateWirelessGatewayResponse> {
            serializer = CreateWirelessGatewayOperationSerializer()
            deserializer = CreateWirelessGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateWirelessGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a task for a wireless gateway.
     */
    override suspend fun createWirelessGatewayTask(input: CreateWirelessGatewayTaskRequest): CreateWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskRequest, CreateWirelessGatewayTaskResponse> {
            serializer = CreateWirelessGatewayTaskOperationSerializer()
            deserializer = CreateWirelessGatewayTaskOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateWirelessGatewayTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway task definition.
     */
    override suspend fun createWirelessGatewayTaskDefinition(input: CreateWirelessGatewayTaskDefinitionRequest): CreateWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<CreateWirelessGatewayTaskDefinitionRequest, CreateWirelessGatewayTaskDefinitionResponse> {
            serializer = CreateWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = CreateWirelessGatewayTaskDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateWirelessGatewayTaskDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a destination.
     */
    override suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse {
        val op = SdkHttpOperation.build<DeleteDestinationRequest, DeleteDestinationResponse> {
            serializer = DeleteDestinationOperationSerializer()
            deserializer = DeleteDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a device profile.
     */
    override suspend fun deleteDeviceProfile(input: DeleteDeviceProfileRequest): DeleteDeviceProfileResponse {
        val op = SdkHttpOperation.build<DeleteDeviceProfileRequest, DeleteDeviceProfileResponse> {
            serializer = DeleteDeviceProfileOperationSerializer()
            deserializer = DeleteDeviceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteDeviceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a FUOTA task.
     */
    override suspend fun deleteFuotaTask(input: DeleteFuotaTaskRequest): DeleteFuotaTaskResponse {
        val op = SdkHttpOperation.build<DeleteFuotaTaskRequest, DeleteFuotaTaskResponse> {
            serializer = DeleteFuotaTaskOperationSerializer()
            deserializer = DeleteFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    override suspend fun deleteMulticastGroup(input: DeleteMulticastGroupRequest): DeleteMulticastGroupResponse {
        val op = SdkHttpOperation.build<DeleteMulticastGroupRequest, DeleteMulticastGroupResponse> {
            serializer = DeleteMulticastGroupOperationSerializer()
            deserializer = DeleteMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network analyzer configuration.
     */
    override suspend fun deleteNetworkAnalyzerConfiguration(input: DeleteNetworkAnalyzerConfigurationRequest): DeleteNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteNetworkAnalyzerConfigurationRequest, DeleteNetworkAnalyzerConfigurationResponse> {
            serializer = DeleteNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = DeleteNetworkAnalyzerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteNetworkAnalyzerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove queued messages from the downlink queue.
     */
    override suspend fun deleteQueuedMessages(input: DeleteQueuedMessagesRequest): DeleteQueuedMessagesResponse {
        val op = SdkHttpOperation.build<DeleteQueuedMessagesRequest, DeleteQueuedMessagesResponse> {
            serializer = DeleteQueuedMessagesOperationSerializer()
            deserializer = DeleteQueuedMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteQueuedMessages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a service profile.
     */
    override suspend fun deleteServiceProfile(input: DeleteServiceProfileRequest): DeleteServiceProfileResponse {
        val op = SdkHttpOperation.build<DeleteServiceProfileRequest, DeleteServiceProfileResponse> {
            serializer = DeleteServiceProfileOperationSerializer()
            deserializer = DeleteServiceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteServiceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless device.
     */
    override suspend fun deleteWirelessDevice(input: DeleteWirelessDeviceRequest): DeleteWirelessDeviceResponse {
        val op = SdkHttpOperation.build<DeleteWirelessDeviceRequest, DeleteWirelessDeviceResponse> {
            serializer = DeleteWirelessDeviceOperationSerializer()
            deserializer = DeleteWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway.
     */
    override suspend fun deleteWirelessGateway(input: DeleteWirelessGatewayRequest): DeleteWirelessGatewayResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayRequest, DeleteWirelessGatewayResponse> {
            serializer = DeleteWirelessGatewayOperationSerializer()
            deserializer = DeleteWirelessGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteWirelessGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task.
     */
    override suspend fun deleteWirelessGatewayTask(input: DeleteWirelessGatewayTaskRequest): DeleteWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskRequest, DeleteWirelessGatewayTaskResponse> {
            serializer = DeleteWirelessGatewayTaskOperationSerializer()
            deserializer = DeleteWirelessGatewayTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteWirelessGatewayTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    override suspend fun deleteWirelessGatewayTaskDefinition(input: DeleteWirelessGatewayTaskDefinitionRequest): DeleteWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteWirelessGatewayTaskDefinitionRequest, DeleteWirelessGatewayTaskDefinitionResponse> {
            serializer = DeleteWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = DeleteWirelessGatewayTaskDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteWirelessGatewayTaskDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    override suspend fun disassociateAwsAccountFromPartnerAccount(input: DisassociateAwsAccountFromPartnerAccountRequest): DisassociateAwsAccountFromPartnerAccountResponse {
        val op = SdkHttpOperation.build<DisassociateAwsAccountFromPartnerAccountRequest, DisassociateAwsAccountFromPartnerAccountResponse> {
            serializer = DisassociateAwsAccountFromPartnerAccountOperationSerializer()
            deserializer = DisassociateAwsAccountFromPartnerAccountOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateAwsAccountFromPartnerAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a multicast group from a fuota task.
     */
    override suspend fun disassociateMulticastGroupFromFuotaTask(input: DisassociateMulticastGroupFromFuotaTaskRequest): DisassociateMulticastGroupFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateMulticastGroupFromFuotaTaskRequest, DisassociateMulticastGroupFromFuotaTaskResponse> {
            serializer = DisassociateMulticastGroupFromFuotaTaskOperationSerializer()
            deserializer = DisassociateMulticastGroupFromFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateMulticastGroupFromFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    override suspend fun disassociateWirelessDeviceFromFuotaTask(input: DisassociateWirelessDeviceFromFuotaTaskRequest): DisassociateWirelessDeviceFromFuotaTaskResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromFuotaTaskRequest, DisassociateWirelessDeviceFromFuotaTaskResponse> {
            serializer = DisassociateWirelessDeviceFromFuotaTaskOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateWirelessDeviceFromFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from a multicast group.
     */
    override suspend fun disassociateWirelessDeviceFromMulticastGroup(input: DisassociateWirelessDeviceFromMulticastGroupRequest): DisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromMulticastGroupRequest, DisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializer = DisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateWirelessDeviceFromMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    override suspend fun disassociateWirelessDeviceFromThing(input: DisassociateWirelessDeviceFromThingRequest): DisassociateWirelessDeviceFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessDeviceFromThingRequest, DisassociateWirelessDeviceFromThingResponse> {
            serializer = DisassociateWirelessDeviceFromThingOperationSerializer()
            deserializer = DisassociateWirelessDeviceFromThingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateWirelessDeviceFromThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    override suspend fun disassociateWirelessGatewayFromCertificate(input: DisassociateWirelessGatewayFromCertificateRequest): DisassociateWirelessGatewayFromCertificateResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromCertificateRequest, DisassociateWirelessGatewayFromCertificateResponse> {
            serializer = DisassociateWirelessGatewayFromCertificateOperationSerializer()
            deserializer = DisassociateWirelessGatewayFromCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateWirelessGatewayFromCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    override suspend fun disassociateWirelessGatewayFromThing(input: DisassociateWirelessGatewayFromThingRequest): DisassociateWirelessGatewayFromThingResponse {
        val op = SdkHttpOperation.build<DisassociateWirelessGatewayFromThingRequest, DisassociateWirelessGatewayFromThingResponse> {
            serializer = DisassociateWirelessGatewayFromThingOperationSerializer()
            deserializer = DisassociateWirelessGatewayFromThingOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DisassociateWirelessGatewayFromThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a destination.
     */
    override suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse {
        val op = SdkHttpOperation.build<GetDestinationRequest, GetDestinationResponse> {
            serializer = GetDestinationOperationSerializer()
            deserializer = GetDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a device profile.
     */
    override suspend fun getDeviceProfile(input: GetDeviceProfileRequest): GetDeviceProfileResponse {
        val op = SdkHttpOperation.build<GetDeviceProfileRequest, GetDeviceProfileResponse> {
            serializer = GetDeviceProfileOperationSerializer()
            deserializer = GetDeviceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDeviceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration by resource types.
     */
    override suspend fun getEventConfigurationByResourceTypes(input: GetEventConfigurationByResourceTypesRequest): GetEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetEventConfigurationByResourceTypesRequest, GetEventConfigurationByResourceTypesResponse> {
            serializer = GetEventConfigurationByResourceTypesOperationSerializer()
            deserializer = GetEventConfigurationByResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEventConfigurationByResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a FUOTA task.
     */
    override suspend fun getFuotaTask(input: GetFuotaTaskRequest): GetFuotaTaskResponse {
        val op = SdkHttpOperation.build<GetFuotaTaskRequest, GetFuotaTaskResponse> {
            serializer = GetFuotaTaskOperationSerializer()
            deserializer = GetFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    override suspend fun getLogLevelsByResourceTypes(input: GetLogLevelsByResourceTypesRequest): GetLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<GetLogLevelsByResourceTypesRequest, GetLogLevelsByResourceTypesResponse> {
            serializer = GetLogLevelsByResourceTypesOperationSerializer()
            deserializer = GetLogLevelsByResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLogLevelsByResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group.
     */
    override suspend fun getMulticastGroup(input: GetMulticastGroupRequest): GetMulticastGroupResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupRequest, GetMulticastGroupResponse> {
            serializer = GetMulticastGroupOperationSerializer()
            deserializer = GetMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a multicast group session.
     */
    override suspend fun getMulticastGroupSession(input: GetMulticastGroupSessionRequest): GetMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<GetMulticastGroupSessionRequest, GetMulticastGroupSessionResponse> {
            serializer = GetMulticastGroupSessionOperationSerializer()
            deserializer = GetMulticastGroupSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMulticastGroupSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get network analyzer configuration.
     */
    override suspend fun getNetworkAnalyzerConfiguration(input: GetNetworkAnalyzerConfigurationRequest): GetNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<GetNetworkAnalyzerConfigurationRequest, GetNetworkAnalyzerConfigurationResponse> {
            serializer = GetNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = GetNetworkAnalyzerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNetworkAnalyzerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    override suspend fun getPartnerAccount(input: GetPartnerAccountRequest): GetPartnerAccountResponse {
        val op = SdkHttpOperation.build<GetPartnerAccountRequest, GetPartnerAccountResponse> {
            serializer = GetPartnerAccountOperationSerializer()
            deserializer = GetPartnerAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPartnerAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get the event configuration for a particular resource identifier.
     */
    override suspend fun getResourceEventConfiguration(input: GetResourceEventConfigurationRequest): GetResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<GetResourceEventConfigurationRequest, GetResourceEventConfigurationResponse> {
            serializer = GetResourceEventConfigurationOperationSerializer()
            deserializer = GetResourceEventConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceEventConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    override suspend fun getResourceLogLevel(input: GetResourceLogLevelRequest): GetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<GetResourceLogLevelRequest, GetResourceLogLevelResponse> {
            serializer = GetResourceLogLevelOperationSerializer()
            deserializer = GetResourceLogLevelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourceLogLevel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    override suspend fun getServiceEndpoint(input: GetServiceEndpointRequest): GetServiceEndpointResponse {
        val op = SdkHttpOperation.build<GetServiceEndpointRequest, GetServiceEndpointResponse> {
            serializer = GetServiceEndpointOperationSerializer()
            deserializer = GetServiceEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a service profile.
     */
    override suspend fun getServiceProfile(input: GetServiceProfileRequest): GetServiceProfileResponse {
        val op = SdkHttpOperation.build<GetServiceProfileRequest, GetServiceProfileResponse> {
            serializer = GetServiceProfileOperationSerializer()
            deserializer = GetServiceProfileOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServiceProfile"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless device.
     */
    override suspend fun getWirelessDevice(input: GetWirelessDeviceRequest): GetWirelessDeviceResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceRequest, GetWirelessDeviceResponse> {
            serializer = GetWirelessDeviceOperationSerializer()
            deserializer = GetWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless device.
     */
    override suspend fun getWirelessDeviceStatistics(input: GetWirelessDeviceStatisticsRequest): GetWirelessDeviceStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessDeviceStatisticsRequest, GetWirelessDeviceStatisticsResponse> {
            serializer = GetWirelessDeviceStatisticsOperationSerializer()
            deserializer = GetWirelessDeviceStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessDeviceStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway.
     */
    override suspend fun getWirelessGateway(input: GetWirelessGatewayRequest): GetWirelessGatewayResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayRequest, GetWirelessGatewayResponse> {
            serializer = GetWirelessGatewayOperationSerializer()
            deserializer = GetWirelessGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    override suspend fun getWirelessGatewayCertificate(input: GetWirelessGatewayCertificateRequest): GetWirelessGatewayCertificateResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayCertificateRequest, GetWirelessGatewayCertificateResponse> {
            serializer = GetWirelessGatewayCertificateOperationSerializer()
            deserializer = GetWirelessGatewayCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGatewayCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayFirmwareInformation(input: GetWirelessGatewayFirmwareInformationRequest): GetWirelessGatewayFirmwareInformationResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayFirmwareInformationRequest, GetWirelessGatewayFirmwareInformationResponse> {
            serializer = GetWirelessGatewayFirmwareInformationOperationSerializer()
            deserializer = GetWirelessGatewayFirmwareInformationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGatewayFirmwareInformation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets operating information about a wireless gateway.
     */
    override suspend fun getWirelessGatewayStatistics(input: GetWirelessGatewayStatisticsRequest): GetWirelessGatewayStatisticsResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayStatisticsRequest, GetWirelessGatewayStatisticsResponse> {
            serializer = GetWirelessGatewayStatisticsOperationSerializer()
            deserializer = GetWirelessGatewayStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGatewayStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task.
     */
    override suspend fun getWirelessGatewayTask(input: GetWirelessGatewayTaskRequest): GetWirelessGatewayTaskResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskRequest, GetWirelessGatewayTaskResponse> {
            serializer = GetWirelessGatewayTaskOperationSerializer()
            deserializer = GetWirelessGatewayTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGatewayTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a wireless gateway task definition.
     */
    override suspend fun getWirelessGatewayTaskDefinition(input: GetWirelessGatewayTaskDefinitionRequest): GetWirelessGatewayTaskDefinitionResponse {
        val op = SdkHttpOperation.build<GetWirelessGatewayTaskDefinitionRequest, GetWirelessGatewayTaskDefinitionResponse> {
            serializer = GetWirelessGatewayTaskDefinitionOperationSerializer()
            deserializer = GetWirelessGatewayTaskDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWirelessGatewayTaskDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the destinations registered to your AWS account.
     */
    override suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse {
        val op = SdkHttpOperation.build<ListDestinationsRequest, ListDestinationsResponse> {
            serializer = ListDestinationsOperationSerializer()
            deserializer = ListDestinationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDestinations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device profiles registered to your AWS account.
     */
    override suspend fun listDeviceProfiles(input: ListDeviceProfilesRequest): ListDeviceProfilesResponse {
        val op = SdkHttpOperation.build<ListDeviceProfilesRequest, ListDeviceProfilesResponse> {
            serializer = ListDeviceProfilesOperationSerializer()
            deserializer = ListDeviceProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeviceProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    override suspend fun listEventConfigurations(input: ListEventConfigurationsRequest): ListEventConfigurationsResponse {
        val op = SdkHttpOperation.build<ListEventConfigurationsRequest, ListEventConfigurationsResponse> {
            serializer = ListEventConfigurationsOperationSerializer()
            deserializer = ListEventConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    override suspend fun listFuotaTasks(input: ListFuotaTasksRequest): ListFuotaTasksResponse {
        val op = SdkHttpOperation.build<ListFuotaTasksRequest, ListFuotaTasksResponse> {
            serializer = ListFuotaTasksOperationSerializer()
            deserializer = ListFuotaTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFuotaTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    override suspend fun listMulticastGroups(input: ListMulticastGroupsRequest): ListMulticastGroupsResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsRequest, ListMulticastGroupsResponse> {
            serializer = ListMulticastGroupsOperationSerializer()
            deserializer = ListMulticastGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMulticastGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all multicast groups associated with a fuota task.
     */
    override suspend fun listMulticastGroupsByFuotaTask(input: ListMulticastGroupsByFuotaTaskRequest): ListMulticastGroupsByFuotaTaskResponse {
        val op = SdkHttpOperation.build<ListMulticastGroupsByFuotaTaskRequest, ListMulticastGroupsByFuotaTaskResponse> {
            serializer = ListMulticastGroupsByFuotaTaskOperationSerializer()
            deserializer = ListMulticastGroupsByFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMulticastGroupsByFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the network analyzer configurations.
     */
    override suspend fun listNetworkAnalyzerConfigurations(input: ListNetworkAnalyzerConfigurationsRequest): ListNetworkAnalyzerConfigurationsResponse {
        val op = SdkHttpOperation.build<ListNetworkAnalyzerConfigurationsRequest, ListNetworkAnalyzerConfigurationsResponse> {
            serializer = ListNetworkAnalyzerConfigurationsOperationSerializer()
            deserializer = ListNetworkAnalyzerConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNetworkAnalyzerConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    override suspend fun listPartnerAccounts(input: ListPartnerAccountsRequest): ListPartnerAccountsResponse {
        val op = SdkHttpOperation.build<ListPartnerAccountsRequest, ListPartnerAccountsResponse> {
            serializer = ListPartnerAccountsOperationSerializer()
            deserializer = ListPartnerAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPartnerAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List queued messages in the downlink queue.
     */
    override suspend fun listQueuedMessages(input: ListQueuedMessagesRequest): ListQueuedMessagesResponse {
        val op = SdkHttpOperation.build<ListQueuedMessagesRequest, ListQueuedMessagesResponse> {
            serializer = ListQueuedMessagesOperationSerializer()
            deserializer = ListQueuedMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListQueuedMessages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the service profiles registered to your AWS account.
     */
    override suspend fun listServiceProfiles(input: ListServiceProfilesRequest): ListServiceProfilesResponse {
        val op = SdkHttpOperation.build<ListServiceProfilesRequest, ListServiceProfilesResponse> {
            serializer = ListServiceProfilesOperationSerializer()
            deserializer = ListServiceProfilesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServiceProfiles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    override suspend fun listWirelessDevices(input: ListWirelessDevicesRequest): ListWirelessDevicesResponse {
        val op = SdkHttpOperation.build<ListWirelessDevicesRequest, ListWirelessDevicesResponse> {
            serializer = ListWirelessDevicesOperationSerializer()
            deserializer = ListWirelessDevicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWirelessDevices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    override suspend fun listWirelessGatewayTaskDefinitions(input: ListWirelessGatewayTaskDefinitionsRequest): ListWirelessGatewayTaskDefinitionsResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewayTaskDefinitionsRequest, ListWirelessGatewayTaskDefinitionsResponse> {
            serializer = ListWirelessGatewayTaskDefinitionsOperationSerializer()
            deserializer = ListWirelessGatewayTaskDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWirelessGatewayTaskDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    override suspend fun listWirelessGateways(input: ListWirelessGatewaysRequest): ListWirelessGatewaysResponse {
        val op = SdkHttpOperation.build<ListWirelessGatewaysRequest, ListWirelessGatewaysResponse> {
            serializer = ListWirelessGatewaysOperationSerializer()
            deserializer = ListWirelessGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWirelessGateways"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    override suspend fun putResourceLogLevel(input: PutResourceLogLevelRequest): PutResourceLogLevelResponse {
        val op = SdkHttpOperation.build<PutResourceLogLevelRequest, PutResourceLogLevelResponse> {
            serializer = PutResourceLogLevelOperationSerializer()
            deserializer = PutResourceLogLevelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourceLogLevel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     */
    override suspend fun resetAllResourceLogLevels(input: ResetAllResourceLogLevelsRequest): ResetAllResourceLogLevelsResponse {
        val op = SdkHttpOperation.build<ResetAllResourceLogLevelsRequest, ResetAllResourceLogLevelsResponse> {
            serializer = ResetAllResourceLogLevelsOperationSerializer()
            deserializer = ResetAllResourceLogLevelsOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "ResetAllResourceLogLevels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    override suspend fun resetResourceLogLevel(input: ResetResourceLogLevelRequest): ResetResourceLogLevelResponse {
        val op = SdkHttpOperation.build<ResetResourceLogLevelRequest, ResetResourceLogLevelResponse> {
            serializer = ResetResourceLogLevelOperationSerializer()
            deserializer = ResetResourceLogLevelOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "ResetResourceLogLevel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends the specified data to a multicast group.
     */
    override suspend fun sendDataToMulticastGroup(input: SendDataToMulticastGroupRequest): SendDataToMulticastGroupResponse {
        val op = SdkHttpOperation.build<SendDataToMulticastGroupRequest, SendDataToMulticastGroupResponse> {
            serializer = SendDataToMulticastGroupOperationSerializer()
            deserializer = SendDataToMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "SendDataToMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a decrypted application data frame to a device.
     */
    override suspend fun sendDataToWirelessDevice(input: SendDataToWirelessDeviceRequest): SendDataToWirelessDeviceResponse {
        val op = SdkHttpOperation.build<SendDataToWirelessDeviceRequest, SendDataToWirelessDeviceResponse> {
            serializer = SendDataToWirelessDeviceOperationSerializer()
            deserializer = SendDataToWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "SendDataToWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    override suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(input: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkAssociateWirelessDeviceWithMulticastGroupRequest, StartBulkAssociateWirelessDeviceWithMulticastGroupResponse> {
            serializer = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationSerializer()
            deserializer = StartBulkAssociateWirelessDeviceWithMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "StartBulkAssociateWirelessDeviceWithMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    override suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(input: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse {
        val op = SdkHttpOperation.build<StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest, StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse> {
            serializer = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationSerializer()
            deserializer = StartBulkDisassociateWirelessDeviceFromMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "StartBulkDisassociateWirelessDeviceFromMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a FUOTA task.
     */
    override suspend fun startFuotaTask(input: StartFuotaTaskRequest): StartFuotaTaskResponse {
        val op = SdkHttpOperation.build<StartFuotaTaskRequest, StartFuotaTaskResponse> {
            serializer = StartFuotaTaskOperationSerializer()
            deserializer = StartFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "StartFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a multicast group session.
     */
    override suspend fun startMulticastGroupSession(input: StartMulticastGroupSessionRequest): StartMulticastGroupSessionResponse {
        val op = SdkHttpOperation.build<StartMulticastGroupSessionRequest, StartMulticastGroupSessionResponse> {
            serializer = StartMulticastGroupSessionOperationSerializer()
            deserializer = StartMulticastGroupSessionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "StartMulticastGroupSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a tag to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    override suspend fun testWirelessDevice(input: TestWirelessDeviceRequest): TestWirelessDeviceResponse {
        val op = SdkHttpOperation.build<TestWirelessDeviceRequest, TestWirelessDeviceResponse> {
            serializer = TestWirelessDeviceOperationSerializer()
            deserializer = TestWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a destination.
     */
    override suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse {
        val op = SdkHttpOperation.build<UpdateDestinationRequest, UpdateDestinationResponse> {
            serializer = UpdateDestinationOperationSerializer()
            deserializer = UpdateDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateDestination"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration by resource types.
     */
    override suspend fun updateEventConfigurationByResourceTypes(input: UpdateEventConfigurationByResourceTypesRequest): UpdateEventConfigurationByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateEventConfigurationByResourceTypesRequest, UpdateEventConfigurationByResourceTypesResponse> {
            serializer = UpdateEventConfigurationByResourceTypesOperationSerializer()
            deserializer = UpdateEventConfigurationByResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateEventConfigurationByResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a FUOTA task.
     */
    override suspend fun updateFuotaTask(input: UpdateFuotaTaskRequest): UpdateFuotaTaskResponse {
        val op = SdkHttpOperation.build<UpdateFuotaTaskRequest, UpdateFuotaTaskResponse> {
            serializer = UpdateFuotaTaskOperationSerializer()
            deserializer = UpdateFuotaTaskOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateFuotaTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    override suspend fun updateLogLevelsByResourceTypes(input: UpdateLogLevelsByResourceTypesRequest): UpdateLogLevelsByResourceTypesResponse {
        val op = SdkHttpOperation.build<UpdateLogLevelsByResourceTypesRequest, UpdateLogLevelsByResourceTypesResponse> {
            serializer = UpdateLogLevelsByResourceTypesOperationSerializer()
            deserializer = UpdateLogLevelsByResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLogLevelsByResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a multicast group session.
     */
    override suspend fun updateMulticastGroup(input: UpdateMulticastGroupRequest): UpdateMulticastGroupResponse {
        val op = SdkHttpOperation.build<UpdateMulticastGroupRequest, UpdateMulticastGroupResponse> {
            serializer = UpdateMulticastGroupOperationSerializer()
            deserializer = UpdateMulticastGroupOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateMulticastGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update network analyzer configuration.
     */
    override suspend fun updateNetworkAnalyzerConfiguration(input: UpdateNetworkAnalyzerConfigurationRequest): UpdateNetworkAnalyzerConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateNetworkAnalyzerConfigurationRequest, UpdateNetworkAnalyzerConfigurationResponse> {
            serializer = UpdateNetworkAnalyzerConfigurationOperationSerializer()
            deserializer = UpdateNetworkAnalyzerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateNetworkAnalyzerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a partner account.
     */
    override suspend fun updatePartnerAccount(input: UpdatePartnerAccountRequest): UpdatePartnerAccountResponse {
        val op = SdkHttpOperation.build<UpdatePartnerAccountRequest, UpdatePartnerAccountResponse> {
            serializer = UpdatePartnerAccountOperationSerializer()
            deserializer = UpdatePartnerAccountOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdatePartnerAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the event configuration for a particular resource identifier.
     */
    override suspend fun updateResourceEventConfiguration(input: UpdateResourceEventConfigurationRequest): UpdateResourceEventConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateResourceEventConfigurationRequest, UpdateResourceEventConfigurationResponse> {
            serializer = UpdateResourceEventConfigurationOperationSerializer()
            deserializer = UpdateResourceEventConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateResourceEventConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless device.
     */
    override suspend fun updateWirelessDevice(input: UpdateWirelessDeviceRequest): UpdateWirelessDeviceResponse {
        val op = SdkHttpOperation.build<UpdateWirelessDeviceRequest, UpdateWirelessDeviceResponse> {
            serializer = UpdateWirelessDeviceOperationSerializer()
            deserializer = UpdateWirelessDeviceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateWirelessDevice"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties of a wireless gateway.
     */
    override suspend fun updateWirelessGateway(input: UpdateWirelessGatewayRequest): UpdateWirelessGatewayResponse {
        val op = SdkHttpOperation.build<UpdateWirelessGatewayRequest, UpdateWirelessGatewayResponse> {
            serializer = UpdateWirelessGatewayOperationSerializer()
            deserializer = UpdateWirelessGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UpdateWirelessGateway"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotwireless"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotwireless")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
