// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotwireless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotwireless.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotwireless.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS IoT Wireless provides bi-directional communication between internet-connected wireless devices and the AWS Cloud. To onboard both LoRaWAN and Sidewalk devices to AWS IoT, use the IoT Wireless API. These wireless devices use the Low Power Wide Area Networking (LPWAN) communication protocol to communicate with AWS IoT.
 *
 * Using the API, you can perform create, read, update, and delete operations for your wireless devices, gateways, destinations, and profiles. After onboarding your devices, you can use the API operations to set log levels and monitor your devices with CloudWatch.
 *
 * You can also use the API operations to create multicast groups and schedule a multicast session for sending a downlink message to devices in the group. By using Firmware Updates Over-The-Air (FUOTA) API operations, you can create a FUOTA task and schedule a session to update the firmware of individual devices or an entire group of devices in a multicast group.
 */
interface IotWirelessClient : SdkClient {

    override val serviceName: String
        get() = "IoT Wireless"
    /**
     * IotWirelessClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IotWirelessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotWirelessClient(config)
        }

        operator fun invoke(config: Config): IotWirelessClient = DefaultIotWirelessClient(config)

        /**
         * Construct a [IotWirelessClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotWirelessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIotWirelessClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a partner account with your AWS account.
     */
    suspend fun associateAwsAccountWithPartnerAccount(input: AssociateAwsAccountWithPartnerAccountRequest): AssociateAwsAccountWithPartnerAccountResponse

    /**
     * Associates a partner account with your AWS account.
     */
    suspend fun associateAwsAccountWithPartnerAccount(block: AssociateAwsAccountWithPartnerAccountRequest.Builder.() -> Unit) = associateAwsAccountWithPartnerAccount(AssociateAwsAccountWithPartnerAccountRequest.Builder().apply(block).build())

    /**
     * Associate a multicast group with a FUOTA task.
     */
    suspend fun associateMulticastGroupWithFuotaTask(input: AssociateMulticastGroupWithFuotaTaskRequest): AssociateMulticastGroupWithFuotaTaskResponse

    /**
     * Associate a multicast group with a FUOTA task.
     */
    suspend fun associateMulticastGroupWithFuotaTask(block: AssociateMulticastGroupWithFuotaTaskRequest.Builder.() -> Unit) = associateMulticastGroupWithFuotaTask(AssociateMulticastGroupWithFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Associate a wireless device with a FUOTA task.
     */
    suspend fun associateWirelessDeviceWithFuotaTask(input: AssociateWirelessDeviceWithFuotaTaskRequest): AssociateWirelessDeviceWithFuotaTaskResponse

    /**
     * Associate a wireless device with a FUOTA task.
     */
    suspend fun associateWirelessDeviceWithFuotaTask(block: AssociateWirelessDeviceWithFuotaTaskRequest.Builder.() -> Unit) = associateWirelessDeviceWithFuotaTask(AssociateWirelessDeviceWithFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Associates a wireless device with a multicast group.
     */
    suspend fun associateWirelessDeviceWithMulticastGroup(input: AssociateWirelessDeviceWithMulticastGroupRequest): AssociateWirelessDeviceWithMulticastGroupResponse

    /**
     * Associates a wireless device with a multicast group.
     */
    suspend fun associateWirelessDeviceWithMulticastGroup(block: AssociateWirelessDeviceWithMulticastGroupRequest.Builder.() -> Unit) = associateWirelessDeviceWithMulticastGroup(AssociateWirelessDeviceWithMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Associates a wireless device with a thing.
     */
    suspend fun associateWirelessDeviceWithThing(input: AssociateWirelessDeviceWithThingRequest): AssociateWirelessDeviceWithThingResponse

    /**
     * Associates a wireless device with a thing.
     */
    suspend fun associateWirelessDeviceWithThing(block: AssociateWirelessDeviceWithThingRequest.Builder.() -> Unit) = associateWirelessDeviceWithThing(AssociateWirelessDeviceWithThingRequest.Builder().apply(block).build())

    /**
     * Associates a wireless gateway with a certificate.
     */
    suspend fun associateWirelessGatewayWithCertificate(input: AssociateWirelessGatewayWithCertificateRequest): AssociateWirelessGatewayWithCertificateResponse

    /**
     * Associates a wireless gateway with a certificate.
     */
    suspend fun associateWirelessGatewayWithCertificate(block: AssociateWirelessGatewayWithCertificateRequest.Builder.() -> Unit) = associateWirelessGatewayWithCertificate(AssociateWirelessGatewayWithCertificateRequest.Builder().apply(block).build())

    /**
     * Associates a wireless gateway with a thing.
     */
    suspend fun associateWirelessGatewayWithThing(input: AssociateWirelessGatewayWithThingRequest): AssociateWirelessGatewayWithThingResponse

    /**
     * Associates a wireless gateway with a thing.
     */
    suspend fun associateWirelessGatewayWithThing(block: AssociateWirelessGatewayWithThingRequest.Builder.() -> Unit) = associateWirelessGatewayWithThing(AssociateWirelessGatewayWithThingRequest.Builder().apply(block).build())

    /**
     * Cancels an existing multicast group session.
     */
    suspend fun cancelMulticastGroupSession(input: CancelMulticastGroupSessionRequest): CancelMulticastGroupSessionResponse

    /**
     * Cancels an existing multicast group session.
     */
    suspend fun cancelMulticastGroupSession(block: CancelMulticastGroupSessionRequest.Builder.() -> Unit) = cancelMulticastGroupSession(CancelMulticastGroupSessionRequest.Builder().apply(block).build())

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse

    /**
     * Creates a new destination that maps a device message to an AWS IoT rule.
     */
    suspend fun createDestination(block: CreateDestinationRequest.Builder.() -> Unit) = createDestination(CreateDestinationRequest.Builder().apply(block).build())

    /**
     * Creates a new device profile.
     */
    suspend fun createDeviceProfile(input: CreateDeviceProfileRequest = CreateDeviceProfileRequest {}): CreateDeviceProfileResponse

    /**
     * Creates a new device profile.
     */
    suspend fun createDeviceProfile(block: CreateDeviceProfileRequest.Builder.() -> Unit) = createDeviceProfile(CreateDeviceProfileRequest.Builder().apply(block).build())

    /**
     * Creates a FUOTA task.
     */
    suspend fun createFuotaTask(input: CreateFuotaTaskRequest): CreateFuotaTaskResponse

    /**
     * Creates a FUOTA task.
     */
    suspend fun createFuotaTask(block: CreateFuotaTaskRequest.Builder.() -> Unit) = createFuotaTask(CreateFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Creates a multicast group.
     */
    suspend fun createMulticastGroup(input: CreateMulticastGroupRequest): CreateMulticastGroupResponse

    /**
     * Creates a multicast group.
     */
    suspend fun createMulticastGroup(block: CreateMulticastGroupRequest.Builder.() -> Unit) = createMulticastGroup(CreateMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new network analyzer configuration.
     */
    suspend fun createNetworkAnalyzerConfiguration(input: CreateNetworkAnalyzerConfigurationRequest): CreateNetworkAnalyzerConfigurationResponse

    /**
     * Creates a new network analyzer configuration.
     */
    suspend fun createNetworkAnalyzerConfiguration(block: CreateNetworkAnalyzerConfigurationRequest.Builder.() -> Unit) = createNetworkAnalyzerConfiguration(CreateNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a new service profile.
     */
    suspend fun createServiceProfile(input: CreateServiceProfileRequest = CreateServiceProfileRequest {}): CreateServiceProfileResponse

    /**
     * Creates a new service profile.
     */
    suspend fun createServiceProfile(block: CreateServiceProfileRequest.Builder.() -> Unit) = createServiceProfile(CreateServiceProfileRequest.Builder().apply(block).build())

    /**
     * Provisions a wireless device.
     */
    suspend fun createWirelessDevice(input: CreateWirelessDeviceRequest): CreateWirelessDeviceResponse

    /**
     * Provisions a wireless device.
     */
    suspend fun createWirelessDevice(block: CreateWirelessDeviceRequest.Builder.() -> Unit) = createWirelessDevice(CreateWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Provisions a wireless gateway.
     */
    suspend fun createWirelessGateway(input: CreateWirelessGatewayRequest): CreateWirelessGatewayResponse

    /**
     * Provisions a wireless gateway.
     */
    suspend fun createWirelessGateway(block: CreateWirelessGatewayRequest.Builder.() -> Unit) = createWirelessGateway(CreateWirelessGatewayRequest.Builder().apply(block).build())

    /**
     * Creates a task for a wireless gateway.
     */
    suspend fun createWirelessGatewayTask(input: CreateWirelessGatewayTaskRequest): CreateWirelessGatewayTaskResponse

    /**
     * Creates a task for a wireless gateway.
     */
    suspend fun createWirelessGatewayTask(block: CreateWirelessGatewayTaskRequest.Builder.() -> Unit) = createWirelessGatewayTask(CreateWirelessGatewayTaskRequest.Builder().apply(block).build())

    /**
     * Creates a gateway task definition.
     */
    suspend fun createWirelessGatewayTaskDefinition(input: CreateWirelessGatewayTaskDefinitionRequest): CreateWirelessGatewayTaskDefinitionResponse

    /**
     * Creates a gateway task definition.
     */
    suspend fun createWirelessGatewayTaskDefinition(block: CreateWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit) = createWirelessGatewayTaskDefinition(CreateWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes a destination.
     */
    suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse

    /**
     * Deletes a destination.
     */
    suspend fun deleteDestination(block: DeleteDestinationRequest.Builder.() -> Unit) = deleteDestination(DeleteDestinationRequest.Builder().apply(block).build())

    /**
     * Deletes a device profile.
     */
    suspend fun deleteDeviceProfile(input: DeleteDeviceProfileRequest): DeleteDeviceProfileResponse

    /**
     * Deletes a device profile.
     */
    suspend fun deleteDeviceProfile(block: DeleteDeviceProfileRequest.Builder.() -> Unit) = deleteDeviceProfile(DeleteDeviceProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a FUOTA task.
     */
    suspend fun deleteFuotaTask(input: DeleteFuotaTaskRequest): DeleteFuotaTaskResponse

    /**
     * Deletes a FUOTA task.
     */
    suspend fun deleteFuotaTask(block: DeleteFuotaTaskRequest.Builder.() -> Unit) = deleteFuotaTask(DeleteFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    suspend fun deleteMulticastGroup(input: DeleteMulticastGroupRequest): DeleteMulticastGroupResponse

    /**
     * Deletes a multicast group if it is not in use by a fuota task.
     */
    suspend fun deleteMulticastGroup(block: DeleteMulticastGroupRequest.Builder.() -> Unit) = deleteMulticastGroup(DeleteMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a network analyzer configuration.
     */
    suspend fun deleteNetworkAnalyzerConfiguration(input: DeleteNetworkAnalyzerConfigurationRequest): DeleteNetworkAnalyzerConfigurationResponse

    /**
     * Deletes a network analyzer configuration.
     */
    suspend fun deleteNetworkAnalyzerConfiguration(block: DeleteNetworkAnalyzerConfigurationRequest.Builder.() -> Unit) = deleteNetworkAnalyzerConfiguration(DeleteNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

    /**
     * Remove queued messages from the downlink queue.
     */
    suspend fun deleteQueuedMessages(input: DeleteQueuedMessagesRequest): DeleteQueuedMessagesResponse

    /**
     * Remove queued messages from the downlink queue.
     */
    suspend fun deleteQueuedMessages(block: DeleteQueuedMessagesRequest.Builder.() -> Unit) = deleteQueuedMessages(DeleteQueuedMessagesRequest.Builder().apply(block).build())

    /**
     * Deletes a service profile.
     */
    suspend fun deleteServiceProfile(input: DeleteServiceProfileRequest): DeleteServiceProfileResponse

    /**
     * Deletes a service profile.
     */
    suspend fun deleteServiceProfile(block: DeleteServiceProfileRequest.Builder.() -> Unit) = deleteServiceProfile(DeleteServiceProfileRequest.Builder().apply(block).build())

    /**
     * Deletes a wireless device.
     */
    suspend fun deleteWirelessDevice(input: DeleteWirelessDeviceRequest): DeleteWirelessDeviceResponse

    /**
     * Deletes a wireless device.
     */
    suspend fun deleteWirelessDevice(block: DeleteWirelessDeviceRequest.Builder.() -> Unit) = deleteWirelessDevice(DeleteWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Deletes a wireless gateway.
     */
    suspend fun deleteWirelessGateway(input: DeleteWirelessGatewayRequest): DeleteWirelessGatewayResponse

    /**
     * Deletes a wireless gateway.
     */
    suspend fun deleteWirelessGateway(block: DeleteWirelessGatewayRequest.Builder.() -> Unit) = deleteWirelessGateway(DeleteWirelessGatewayRequest.Builder().apply(block).build())

    /**
     * Deletes a wireless gateway task.
     */
    suspend fun deleteWirelessGatewayTask(input: DeleteWirelessGatewayTaskRequest): DeleteWirelessGatewayTaskResponse

    /**
     * Deletes a wireless gateway task.
     */
    suspend fun deleteWirelessGatewayTask(block: DeleteWirelessGatewayTaskRequest.Builder.() -> Unit) = deleteWirelessGatewayTask(DeleteWirelessGatewayTaskRequest.Builder().apply(block).build())

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    suspend fun deleteWirelessGatewayTaskDefinition(input: DeleteWirelessGatewayTaskDefinitionRequest): DeleteWirelessGatewayTaskDefinitionResponse

    /**
     * Deletes a wireless gateway task definition. Deleting this task definition does not affect tasks that are currently in progress.
     */
    suspend fun deleteWirelessGatewayTaskDefinition(block: DeleteWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit) = deleteWirelessGatewayTaskDefinition(DeleteWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    suspend fun disassociateAwsAccountFromPartnerAccount(input: DisassociateAwsAccountFromPartnerAccountRequest): DisassociateAwsAccountFromPartnerAccountResponse

    /**
     * Disassociates your AWS account from a partner account. If `PartnerAccountId` and `PartnerType` are `null`, disassociates your AWS account from all partner accounts.
     */
    suspend fun disassociateAwsAccountFromPartnerAccount(block: DisassociateAwsAccountFromPartnerAccountRequest.Builder.() -> Unit) = disassociateAwsAccountFromPartnerAccount(DisassociateAwsAccountFromPartnerAccountRequest.Builder().apply(block).build())

    /**
     * Disassociates a multicast group from a fuota task.
     */
    suspend fun disassociateMulticastGroupFromFuotaTask(input: DisassociateMulticastGroupFromFuotaTaskRequest): DisassociateMulticastGroupFromFuotaTaskResponse

    /**
     * Disassociates a multicast group from a fuota task.
     */
    suspend fun disassociateMulticastGroupFromFuotaTask(block: DisassociateMulticastGroupFromFuotaTaskRequest.Builder.() -> Unit) = disassociateMulticastGroupFromFuotaTask(DisassociateMulticastGroupFromFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    suspend fun disassociateWirelessDeviceFromFuotaTask(input: DisassociateWirelessDeviceFromFuotaTaskRequest): DisassociateWirelessDeviceFromFuotaTaskResponse

    /**
     * Disassociates a wireless device from a FUOTA task.
     */
    suspend fun disassociateWirelessDeviceFromFuotaTask(block: DisassociateWirelessDeviceFromFuotaTaskRequest.Builder.() -> Unit) = disassociateWirelessDeviceFromFuotaTask(DisassociateWirelessDeviceFromFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Disassociates a wireless device from a multicast group.
     */
    suspend fun disassociateWirelessDeviceFromMulticastGroup(input: DisassociateWirelessDeviceFromMulticastGroupRequest): DisassociateWirelessDeviceFromMulticastGroupResponse

    /**
     * Disassociates a wireless device from a multicast group.
     */
    suspend fun disassociateWirelessDeviceFromMulticastGroup(block: DisassociateWirelessDeviceFromMulticastGroupRequest.Builder.() -> Unit) = disassociateWirelessDeviceFromMulticastGroup(DisassociateWirelessDeviceFromMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    suspend fun disassociateWirelessDeviceFromThing(input: DisassociateWirelessDeviceFromThingRequest): DisassociateWirelessDeviceFromThingResponse

    /**
     * Disassociates a wireless device from its currently associated thing.
     */
    suspend fun disassociateWirelessDeviceFromThing(block: DisassociateWirelessDeviceFromThingRequest.Builder.() -> Unit) = disassociateWirelessDeviceFromThing(DisassociateWirelessDeviceFromThingRequest.Builder().apply(block).build())

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    suspend fun disassociateWirelessGatewayFromCertificate(input: DisassociateWirelessGatewayFromCertificateRequest): DisassociateWirelessGatewayFromCertificateResponse

    /**
     * Disassociates a wireless gateway from its currently associated certificate.
     */
    suspend fun disassociateWirelessGatewayFromCertificate(block: DisassociateWirelessGatewayFromCertificateRequest.Builder.() -> Unit) = disassociateWirelessGatewayFromCertificate(DisassociateWirelessGatewayFromCertificateRequest.Builder().apply(block).build())

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    suspend fun disassociateWirelessGatewayFromThing(input: DisassociateWirelessGatewayFromThingRequest): DisassociateWirelessGatewayFromThingResponse

    /**
     * Disassociates a wireless gateway from its currently associated thing.
     */
    suspend fun disassociateWirelessGatewayFromThing(block: DisassociateWirelessGatewayFromThingRequest.Builder.() -> Unit) = disassociateWirelessGatewayFromThing(DisassociateWirelessGatewayFromThingRequest.Builder().apply(block).build())

    /**
     * Gets information about a destination.
     */
    suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse

    /**
     * Gets information about a destination.
     */
    suspend fun getDestination(block: GetDestinationRequest.Builder.() -> Unit) = getDestination(GetDestinationRequest.Builder().apply(block).build())

    /**
     * Gets information about a device profile.
     */
    suspend fun getDeviceProfile(input: GetDeviceProfileRequest): GetDeviceProfileResponse

    /**
     * Gets information about a device profile.
     */
    suspend fun getDeviceProfile(block: GetDeviceProfileRequest.Builder.() -> Unit) = getDeviceProfile(GetDeviceProfileRequest.Builder().apply(block).build())

    /**
     * Get the event configuration by resource types.
     */
    suspend fun getEventConfigurationByResourceTypes(input: GetEventConfigurationByResourceTypesRequest = GetEventConfigurationByResourceTypesRequest {}): GetEventConfigurationByResourceTypesResponse

    /**
     * Get the event configuration by resource types.
     */
    suspend fun getEventConfigurationByResourceTypes(block: GetEventConfigurationByResourceTypesRequest.Builder.() -> Unit) = getEventConfigurationByResourceTypes(GetEventConfigurationByResourceTypesRequest.Builder().apply(block).build())

    /**
     * Gets information about a FUOTA task.
     */
    suspend fun getFuotaTask(input: GetFuotaTaskRequest): GetFuotaTaskResponse

    /**
     * Gets information about a FUOTA task.
     */
    suspend fun getFuotaTask(block: GetFuotaTaskRequest.Builder.() -> Unit) = getFuotaTask(GetFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    suspend fun getLogLevelsByResourceTypes(input: GetLogLevelsByResourceTypesRequest = GetLogLevelsByResourceTypesRequest {}): GetLogLevelsByResourceTypesResponse

    /**
     * Returns current default log levels or log levels by resource types. Based on resource types, log levels can be for wireless device log options or wireless gateway log options.
     */
    suspend fun getLogLevelsByResourceTypes(block: GetLogLevelsByResourceTypesRequest.Builder.() -> Unit) = getLogLevelsByResourceTypes(GetLogLevelsByResourceTypesRequest.Builder().apply(block).build())

    /**
     * Gets information about a multicast group.
     */
    suspend fun getMulticastGroup(input: GetMulticastGroupRequest): GetMulticastGroupResponse

    /**
     * Gets information about a multicast group.
     */
    suspend fun getMulticastGroup(block: GetMulticastGroupRequest.Builder.() -> Unit) = getMulticastGroup(GetMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Gets information about a multicast group session.
     */
    suspend fun getMulticastGroupSession(input: GetMulticastGroupSessionRequest): GetMulticastGroupSessionResponse

    /**
     * Gets information about a multicast group session.
     */
    suspend fun getMulticastGroupSession(block: GetMulticastGroupSessionRequest.Builder.() -> Unit) = getMulticastGroupSession(GetMulticastGroupSessionRequest.Builder().apply(block).build())

    /**
     * Get network analyzer configuration.
     */
    suspend fun getNetworkAnalyzerConfiguration(input: GetNetworkAnalyzerConfigurationRequest): GetNetworkAnalyzerConfigurationResponse

    /**
     * Get network analyzer configuration.
     */
    suspend fun getNetworkAnalyzerConfiguration(block: GetNetworkAnalyzerConfigurationRequest.Builder.() -> Unit) = getNetworkAnalyzerConfiguration(GetNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    suspend fun getPartnerAccount(input: GetPartnerAccountRequest): GetPartnerAccountResponse

    /**
     * Gets information about a partner account. If `PartnerAccountId` and `PartnerType` are `null`, returns all partner accounts.
     */
    suspend fun getPartnerAccount(block: GetPartnerAccountRequest.Builder.() -> Unit) = getPartnerAccount(GetPartnerAccountRequest.Builder().apply(block).build())

    /**
     * Get the event configuration for a particular resource identifier.
     */
    suspend fun getResourceEventConfiguration(input: GetResourceEventConfigurationRequest): GetResourceEventConfigurationResponse

    /**
     * Get the event configuration for a particular resource identifier.
     */
    suspend fun getResourceEventConfiguration(block: GetResourceEventConfigurationRequest.Builder.() -> Unit) = getResourceEventConfiguration(GetResourceEventConfigurationRequest.Builder().apply(block).build())

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    suspend fun getResourceLogLevel(input: GetResourceLogLevelRequest): GetResourceLogLevelResponse

    /**
     * Fetches the log-level override, if any, for a given resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    suspend fun getResourceLogLevel(block: GetResourceLogLevelRequest.Builder.() -> Unit) = getResourceLogLevel(GetResourceLogLevelRequest.Builder().apply(block).build())

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    suspend fun getServiceEndpoint(input: GetServiceEndpointRequest = GetServiceEndpointRequest {}): GetServiceEndpointResponse

    /**
     * Gets the account-specific endpoint for Configuration and Update Server (CUPS) protocol or LoRaWAN Network Server (LNS) connections.
     */
    suspend fun getServiceEndpoint(block: GetServiceEndpointRequest.Builder.() -> Unit) = getServiceEndpoint(GetServiceEndpointRequest.Builder().apply(block).build())

    /**
     * Gets information about a service profile.
     */
    suspend fun getServiceProfile(input: GetServiceProfileRequest): GetServiceProfileResponse

    /**
     * Gets information about a service profile.
     */
    suspend fun getServiceProfile(block: GetServiceProfileRequest.Builder.() -> Unit) = getServiceProfile(GetServiceProfileRequest.Builder().apply(block).build())

    /**
     * Gets information about a wireless device.
     */
    suspend fun getWirelessDevice(input: GetWirelessDeviceRequest): GetWirelessDeviceResponse

    /**
     * Gets information about a wireless device.
     */
    suspend fun getWirelessDevice(block: GetWirelessDeviceRequest.Builder.() -> Unit) = getWirelessDevice(GetWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Gets operating information about a wireless device.
     */
    suspend fun getWirelessDeviceStatistics(input: GetWirelessDeviceStatisticsRequest): GetWirelessDeviceStatisticsResponse

    /**
     * Gets operating information about a wireless device.
     */
    suspend fun getWirelessDeviceStatistics(block: GetWirelessDeviceStatisticsRequest.Builder.() -> Unit) = getWirelessDeviceStatistics(GetWirelessDeviceStatisticsRequest.Builder().apply(block).build())

    /**
     * Gets information about a wireless gateway.
     */
    suspend fun getWirelessGateway(input: GetWirelessGatewayRequest): GetWirelessGatewayResponse

    /**
     * Gets information about a wireless gateway.
     */
    suspend fun getWirelessGateway(block: GetWirelessGatewayRequest.Builder.() -> Unit) = getWirelessGateway(GetWirelessGatewayRequest.Builder().apply(block).build())

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    suspend fun getWirelessGatewayCertificate(input: GetWirelessGatewayCertificateRequest): GetWirelessGatewayCertificateResponse

    /**
     * Gets the ID of the certificate that is currently associated with a wireless gateway.
     */
    suspend fun getWirelessGatewayCertificate(block: GetWirelessGatewayCertificateRequest.Builder.() -> Unit) = getWirelessGatewayCertificate(GetWirelessGatewayCertificateRequest.Builder().apply(block).build())

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    suspend fun getWirelessGatewayFirmwareInformation(input: GetWirelessGatewayFirmwareInformationRequest): GetWirelessGatewayFirmwareInformationResponse

    /**
     * Gets the firmware version and other information about a wireless gateway.
     */
    suspend fun getWirelessGatewayFirmwareInformation(block: GetWirelessGatewayFirmwareInformationRequest.Builder.() -> Unit) = getWirelessGatewayFirmwareInformation(GetWirelessGatewayFirmwareInformationRequest.Builder().apply(block).build())

    /**
     * Gets operating information about a wireless gateway.
     */
    suspend fun getWirelessGatewayStatistics(input: GetWirelessGatewayStatisticsRequest): GetWirelessGatewayStatisticsResponse

    /**
     * Gets operating information about a wireless gateway.
     */
    suspend fun getWirelessGatewayStatistics(block: GetWirelessGatewayStatisticsRequest.Builder.() -> Unit) = getWirelessGatewayStatistics(GetWirelessGatewayStatisticsRequest.Builder().apply(block).build())

    /**
     * Gets information about a wireless gateway task.
     */
    suspend fun getWirelessGatewayTask(input: GetWirelessGatewayTaskRequest): GetWirelessGatewayTaskResponse

    /**
     * Gets information about a wireless gateway task.
     */
    suspend fun getWirelessGatewayTask(block: GetWirelessGatewayTaskRequest.Builder.() -> Unit) = getWirelessGatewayTask(GetWirelessGatewayTaskRequest.Builder().apply(block).build())

    /**
     * Gets information about a wireless gateway task definition.
     */
    suspend fun getWirelessGatewayTaskDefinition(input: GetWirelessGatewayTaskDefinitionRequest): GetWirelessGatewayTaskDefinitionResponse

    /**
     * Gets information about a wireless gateway task definition.
     */
    suspend fun getWirelessGatewayTaskDefinition(block: GetWirelessGatewayTaskDefinitionRequest.Builder.() -> Unit) = getWirelessGatewayTaskDefinition(GetWirelessGatewayTaskDefinitionRequest.Builder().apply(block).build())

    /**
     * Lists the destinations registered to your AWS account.
     */
    suspend fun listDestinations(input: ListDestinationsRequest = ListDestinationsRequest {}): ListDestinationsResponse

    /**
     * Lists the destinations registered to your AWS account.
     */
    suspend fun listDestinations(block: ListDestinationsRequest.Builder.() -> Unit) = listDestinations(ListDestinationsRequest.Builder().apply(block).build())

    /**
     * Lists the device profiles registered to your AWS account.
     */
    suspend fun listDeviceProfiles(input: ListDeviceProfilesRequest = ListDeviceProfilesRequest {}): ListDeviceProfilesResponse

    /**
     * Lists the device profiles registered to your AWS account.
     */
    suspend fun listDeviceProfiles(block: ListDeviceProfilesRequest.Builder.() -> Unit) = listDeviceProfiles(ListDeviceProfilesRequest.Builder().apply(block).build())

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    suspend fun listEventConfigurations(input: ListEventConfigurationsRequest): ListEventConfigurationsResponse

    /**
     * List event configurations where at least one event topic has been enabled.
     */
    suspend fun listEventConfigurations(block: ListEventConfigurationsRequest.Builder.() -> Unit) = listEventConfigurations(ListEventConfigurationsRequest.Builder().apply(block).build())

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    suspend fun listFuotaTasks(input: ListFuotaTasksRequest = ListFuotaTasksRequest {}): ListFuotaTasksResponse

    /**
     * Lists the FUOTA tasks registered to your AWS account.
     */
    suspend fun listFuotaTasks(block: ListFuotaTasksRequest.Builder.() -> Unit) = listFuotaTasks(ListFuotaTasksRequest.Builder().apply(block).build())

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    suspend fun listMulticastGroups(input: ListMulticastGroupsRequest = ListMulticastGroupsRequest {}): ListMulticastGroupsResponse

    /**
     * Lists the multicast groups registered to your AWS account.
     */
    suspend fun listMulticastGroups(block: ListMulticastGroupsRequest.Builder.() -> Unit) = listMulticastGroups(ListMulticastGroupsRequest.Builder().apply(block).build())

    /**
     * List all multicast groups associated with a fuota task.
     */
    suspend fun listMulticastGroupsByFuotaTask(input: ListMulticastGroupsByFuotaTaskRequest): ListMulticastGroupsByFuotaTaskResponse

    /**
     * List all multicast groups associated with a fuota task.
     */
    suspend fun listMulticastGroupsByFuotaTask(block: ListMulticastGroupsByFuotaTaskRequest.Builder.() -> Unit) = listMulticastGroupsByFuotaTask(ListMulticastGroupsByFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Lists the network analyzer configurations.
     */
    suspend fun listNetworkAnalyzerConfigurations(input: ListNetworkAnalyzerConfigurationsRequest = ListNetworkAnalyzerConfigurationsRequest {}): ListNetworkAnalyzerConfigurationsResponse

    /**
     * Lists the network analyzer configurations.
     */
    suspend fun listNetworkAnalyzerConfigurations(block: ListNetworkAnalyzerConfigurationsRequest.Builder.() -> Unit) = listNetworkAnalyzerConfigurations(ListNetworkAnalyzerConfigurationsRequest.Builder().apply(block).build())

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    suspend fun listPartnerAccounts(input: ListPartnerAccountsRequest = ListPartnerAccountsRequest {}): ListPartnerAccountsResponse

    /**
     * Lists the partner accounts associated with your AWS account.
     */
    suspend fun listPartnerAccounts(block: ListPartnerAccountsRequest.Builder.() -> Unit) = listPartnerAccounts(ListPartnerAccountsRequest.Builder().apply(block).build())

    /**
     * List queued messages in the downlink queue.
     */
    suspend fun listQueuedMessages(input: ListQueuedMessagesRequest): ListQueuedMessagesResponse

    /**
     * List queued messages in the downlink queue.
     */
    suspend fun listQueuedMessages(block: ListQueuedMessagesRequest.Builder.() -> Unit) = listQueuedMessages(ListQueuedMessagesRequest.Builder().apply(block).build())

    /**
     * Lists the service profiles registered to your AWS account.
     */
    suspend fun listServiceProfiles(input: ListServiceProfilesRequest = ListServiceProfilesRequest {}): ListServiceProfilesResponse

    /**
     * Lists the service profiles registered to your AWS account.
     */
    suspend fun listServiceProfiles(block: ListServiceProfilesRequest.Builder.() -> Unit) = listServiceProfiles(ListServiceProfilesRequest.Builder().apply(block).build())

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    suspend fun listWirelessDevices(input: ListWirelessDevicesRequest = ListWirelessDevicesRequest {}): ListWirelessDevicesResponse

    /**
     * Lists the wireless devices registered to your AWS account.
     */
    suspend fun listWirelessDevices(block: ListWirelessDevicesRequest.Builder.() -> Unit) = listWirelessDevices(ListWirelessDevicesRequest.Builder().apply(block).build())

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    suspend fun listWirelessGatewayTaskDefinitions(input: ListWirelessGatewayTaskDefinitionsRequest = ListWirelessGatewayTaskDefinitionsRequest {}): ListWirelessGatewayTaskDefinitionsResponse

    /**
     * List the wireless gateway tasks definitions registered to your AWS account.
     */
    suspend fun listWirelessGatewayTaskDefinitions(block: ListWirelessGatewayTaskDefinitionsRequest.Builder.() -> Unit) = listWirelessGatewayTaskDefinitions(ListWirelessGatewayTaskDefinitionsRequest.Builder().apply(block).build())

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    suspend fun listWirelessGateways(input: ListWirelessGatewaysRequest = ListWirelessGatewaysRequest {}): ListWirelessGatewaysResponse

    /**
     * Lists the wireless gateways registered to your AWS account.
     */
    suspend fun listWirelessGateways(block: ListWirelessGatewaysRequest.Builder.() -> Unit) = listWirelessGateways(ListWirelessGatewaysRequest.Builder().apply(block).build())

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    suspend fun putResourceLogLevel(input: PutResourceLogLevelRequest): PutResourceLogLevelResponse

    /**
     * Sets the log-level override for a resource-ID and resource-type. This option can be specified for a wireless gateway or a wireless device. A limit of 200 log level override can be set per account.
     */
    suspend fun putResourceLogLevel(block: PutResourceLogLevelRequest.Builder.() -> Unit) = putResourceLogLevel(PutResourceLogLevelRequest.Builder().apply(block).build())

    /**
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     */
    suspend fun resetAllResourceLogLevels(input: ResetAllResourceLogLevelsRequest = ResetAllResourceLogLevelsRequest {}): ResetAllResourceLogLevelsResponse

    /**
     * Removes the log-level overrides for all resources; both wireless devices and wireless gateways.
     */
    suspend fun resetAllResourceLogLevels(block: ResetAllResourceLogLevelsRequest.Builder.() -> Unit) = resetAllResourceLogLevels(ResetAllResourceLogLevelsRequest.Builder().apply(block).build())

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    suspend fun resetResourceLogLevel(input: ResetResourceLogLevelRequest): ResetResourceLogLevelResponse

    /**
     * Removes the log-level override, if any, for a specific resource-ID and resource-type. It can be used for a wireless device or a wireless gateway.
     */
    suspend fun resetResourceLogLevel(block: ResetResourceLogLevelRequest.Builder.() -> Unit) = resetResourceLogLevel(ResetResourceLogLevelRequest.Builder().apply(block).build())

    /**
     * Sends the specified data to a multicast group.
     */
    suspend fun sendDataToMulticastGroup(input: SendDataToMulticastGroupRequest): SendDataToMulticastGroupResponse

    /**
     * Sends the specified data to a multicast group.
     */
    suspend fun sendDataToMulticastGroup(block: SendDataToMulticastGroupRequest.Builder.() -> Unit) = sendDataToMulticastGroup(SendDataToMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Sends a decrypted application data frame to a device.
     */
    suspend fun sendDataToWirelessDevice(input: SendDataToWirelessDeviceRequest): SendDataToWirelessDeviceResponse

    /**
     * Sends a decrypted application data frame to a device.
     */
    suspend fun sendDataToWirelessDevice(block: SendDataToWirelessDeviceRequest.Builder.() -> Unit) = sendDataToWirelessDevice(SendDataToWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(input: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest): StartBulkAssociateWirelessDeviceWithMulticastGroupResponse

    /**
     * Starts a bulk association of all qualifying wireless devices with a multicast group.
     */
    suspend fun startBulkAssociateWirelessDeviceWithMulticastGroup(block: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder.() -> Unit) = startBulkAssociateWirelessDeviceWithMulticastGroup(StartBulkAssociateWirelessDeviceWithMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(input: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest): StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse

    /**
     * Starts a bulk disassociatin of all qualifying wireless devices from a multicast group.
     */
    suspend fun startBulkDisassociateWirelessDeviceFromMulticastGroup(block: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder.() -> Unit) = startBulkDisassociateWirelessDeviceFromMulticastGroup(StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Starts a FUOTA task.
     */
    suspend fun startFuotaTask(input: StartFuotaTaskRequest): StartFuotaTaskResponse

    /**
     * Starts a FUOTA task.
     */
    suspend fun startFuotaTask(block: StartFuotaTaskRequest.Builder.() -> Unit) = startFuotaTask(StartFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Starts a multicast group session.
     */
    suspend fun startMulticastGroupSession(input: StartMulticastGroupSessionRequest): StartMulticastGroupSessionResponse

    /**
     * Starts a multicast group session.
     */
    suspend fun startMulticastGroupSession(block: StartMulticastGroupSessionRequest.Builder.() -> Unit) = startMulticastGroupSession(StartMulticastGroupSessionRequest.Builder().apply(block).build())

    /**
     * Adds a tag to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds a tag to a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    suspend fun testWirelessDevice(input: TestWirelessDeviceRequest): TestWirelessDeviceResponse

    /**
     * Simulates a provisioned device by sending an uplink data payload of `Hello`.
     */
    suspend fun testWirelessDevice(block: TestWirelessDeviceRequest.Builder.() -> Unit) = testWirelessDevice(TestWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates properties of a destination.
     */
    suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse

    /**
     * Updates properties of a destination.
     */
    suspend fun updateDestination(block: UpdateDestinationRequest.Builder.() -> Unit) = updateDestination(UpdateDestinationRequest.Builder().apply(block).build())

    /**
     * Update the event configuration by resource types.
     */
    suspend fun updateEventConfigurationByResourceTypes(input: UpdateEventConfigurationByResourceTypesRequest = UpdateEventConfigurationByResourceTypesRequest {}): UpdateEventConfigurationByResourceTypesResponse

    /**
     * Update the event configuration by resource types.
     */
    suspend fun updateEventConfigurationByResourceTypes(block: UpdateEventConfigurationByResourceTypesRequest.Builder.() -> Unit) = updateEventConfigurationByResourceTypes(UpdateEventConfigurationByResourceTypesRequest.Builder().apply(block).build())

    /**
     * Updates properties of a FUOTA task.
     */
    suspend fun updateFuotaTask(input: UpdateFuotaTaskRequest): UpdateFuotaTaskResponse

    /**
     * Updates properties of a FUOTA task.
     */
    suspend fun updateFuotaTask(block: UpdateFuotaTaskRequest.Builder.() -> Unit) = updateFuotaTask(UpdateFuotaTaskRequest.Builder().apply(block).build())

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    suspend fun updateLogLevelsByResourceTypes(input: UpdateLogLevelsByResourceTypesRequest = UpdateLogLevelsByResourceTypesRequest {}): UpdateLogLevelsByResourceTypesResponse

    /**
     * Set default log level, or log levels by resource types. This can be for wireless device log options or wireless gateways log options and is used to control the log messages that'll be displayed in CloudWatch.
     */
    suspend fun updateLogLevelsByResourceTypes(block: UpdateLogLevelsByResourceTypesRequest.Builder.() -> Unit) = updateLogLevelsByResourceTypes(UpdateLogLevelsByResourceTypesRequest.Builder().apply(block).build())

    /**
     * Updates properties of a multicast group session.
     */
    suspend fun updateMulticastGroup(input: UpdateMulticastGroupRequest): UpdateMulticastGroupResponse

    /**
     * Updates properties of a multicast group session.
     */
    suspend fun updateMulticastGroup(block: UpdateMulticastGroupRequest.Builder.() -> Unit) = updateMulticastGroup(UpdateMulticastGroupRequest.Builder().apply(block).build())

    /**
     * Update network analyzer configuration.
     */
    suspend fun updateNetworkAnalyzerConfiguration(input: UpdateNetworkAnalyzerConfigurationRequest): UpdateNetworkAnalyzerConfigurationResponse

    /**
     * Update network analyzer configuration.
     */
    suspend fun updateNetworkAnalyzerConfiguration(block: UpdateNetworkAnalyzerConfigurationRequest.Builder.() -> Unit) = updateNetworkAnalyzerConfiguration(UpdateNetworkAnalyzerConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates properties of a partner account.
     */
    suspend fun updatePartnerAccount(input: UpdatePartnerAccountRequest): UpdatePartnerAccountResponse

    /**
     * Updates properties of a partner account.
     */
    suspend fun updatePartnerAccount(block: UpdatePartnerAccountRequest.Builder.() -> Unit) = updatePartnerAccount(UpdatePartnerAccountRequest.Builder().apply(block).build())

    /**
     * Update the event configuration for a particular resource identifier.
     */
    suspend fun updateResourceEventConfiguration(input: UpdateResourceEventConfigurationRequest): UpdateResourceEventConfigurationResponse

    /**
     * Update the event configuration for a particular resource identifier.
     */
    suspend fun updateResourceEventConfiguration(block: UpdateResourceEventConfigurationRequest.Builder.() -> Unit) = updateResourceEventConfiguration(UpdateResourceEventConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates properties of a wireless device.
     */
    suspend fun updateWirelessDevice(input: UpdateWirelessDeviceRequest): UpdateWirelessDeviceResponse

    /**
     * Updates properties of a wireless device.
     */
    suspend fun updateWirelessDevice(block: UpdateWirelessDeviceRequest.Builder.() -> Unit) = updateWirelessDevice(UpdateWirelessDeviceRequest.Builder().apply(block).build())

    /**
     * Updates properties of a wireless gateway.
     */
    suspend fun updateWirelessGateway(input: UpdateWirelessGatewayRequest): UpdateWirelessGatewayResponse

    /**
     * Updates properties of a wireless gateway.
     */
    suspend fun updateWirelessGateway(block: UpdateWirelessGatewayRequest.Builder.() -> Unit) = updateWirelessGateway(UpdateWirelessGatewayRequest.Builder().apply(block).build())
}
