// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ivs.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ivs.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * **Introduction**
 *
 * The Amazon Interactive Video Service (IVS) API is REST compatible, using a standard HTTP API and an Amazon Web Services EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 *
 * The API is an Amazon Web Services regional service. For a list of supported regions and Amazon IVS HTTPS service endpoints, see the [Amazon IVS page](https://docs.aws.amazon.com/general/latest/gr/ivs.html) in the *Amazon Web Services General Reference*.
 *
 * ***All API request parameters and URLs are case sensitive. ***
 *
 * For a summary of notable documentation changes in each release, see [ Document History](https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html).
 *
 * **Allowed Header Values**
 * + ` <b>Accept:</b> ` application/json
 * + ` <b>Accept-Encoding:</b> ` gzip, deflate
 * + ` <b>Content-Type:</b> `application/json
 *
 * **Resources**
 *
 * The following resources contain information about your IVS live stream (see [ Getting Started with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html)):
 * + Channel — Stores configuration data related to your live stream. You first create a channel and then use the channel’s stream key to start your live stream. See the Channel endpoints for more information.
 * + Stream key — An identifier assigned by Amazon IVS when you create a channel, which is then used to authorize streaming. See the StreamKey endpoints for more information. ***Treat the stream key like a secret, since it allows anyone to stream to the channel.***
 * + Playback key pair — Video playback may be restricted using playback-authorization tokens, which use public-key encryption. A playback key pair is the public-private pair of keys used to sign and validate the playback-authorization token. See the PlaybackKeyPair endpoints for more information.
 * + Recording configuration — Stores configuration related to recording a live stream and where to store the recorded content. Multiple channels can reference the same recording configuration. See the Recording Configuration endpoints for more information.
 *
 * **Tagging**
 *
 * A *tag* is a metadata label that you assign to an Amazon Web Services resource. A tag comprises a *key* and a *value*, both set by you. For example, you might set a tag as `topic:nature` to label a particular video category. See [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags.
 *
 * Tags can help you identify and organize your Amazon Web Services resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see [ Access Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
 *
 * The Amazon IVS API has these tag-related endpoints: TagResource, UntagResource, and ListTagsForResource. The following resources support tagging: Channels, Stream Keys, Playback Key Pairs, and Recording Configurations.
 *
 * At most 50 tags can be applied to a resource.
 *
 * **Authentication versus Authorization**
 *
 * Note the differences between these concepts:
 * + *Authentication* is about verifying identity. You need to be authenticated to sign Amazon IVS API requests.
 * + *Authorization* is about granting permissions. You need to be authorized to view [Amazon IVS private channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html). (Private channels are channels that are enabled for "playback authorization.")
 *
 * **Authentication**
 *
 * All Amazon IVS API requests must be authenticated with a signature. The Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS API directly, it’s your responsibility to sign the requests.
 *
 * You generate a signature using valid Amazon Web Services credentials that have permission to perform the requested action. For example, you must sign PutMetadata requests with a signature generated from an IAM user account that has the `ivs:PutMetadata` permission.
 *
 * For more information:
 * + Authentication and generating signatures — See [Authenticating Requests (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html) in the *Amazon Web Services General Reference*.
 * + Managing Amazon IVS permissions — See [Identity and Access Management](https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html) on the Security page of the *Amazon IVS User Guide*.
 *
 * **Channel Endpoints**
 * + CreateChannel — Creates a new channel and an associated stream key to start streaming.
 * + GetChannel — Gets the channel configuration for the specified channel ARN (Amazon Resource Name).
 * + BatchGetChannel — Performs GetChannel on multiple ARNs simultaneously.
 * + ListChannels — Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 Conflict Exception).
 * + UpdateChannel — Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
 * + DeleteChannel — Deletes the specified channel.
 *
 * **StreamKey Endpoints**
 * + CreateStreamKey — Creates a stream key, used to initiate a stream, for the specified channel ARN.
 * + GetStreamKey — Gets stream key information for the specified ARN.
 * + BatchGetStreamKey — Performs GetStreamKey on multiple ARNs simultaneously.
 * + ListStreamKeys — Gets summary information about stream keys for the specified channel.
 * + DeleteStreamKey — Deletes the stream key for the specified ARN, so it can no longer be used to stream.
 *
 * **Stream Endpoints**
 * + GetStream — Gets information about the active (live) stream on a specified channel.
 * + GetStreamSession — Gets metadata on a specified stream.
 * + ListStreams — Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
 * + ListStreamSessions — Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
 * + StopStream — Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
 * + PutMetadata — Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed.
 *
 * **PlaybackKeyPair Endpoints**
 *
 * For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
 * + ImportPlaybackKeyPair — Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels (channels enabled for playback authorization).
 * + GetPlaybackKeyPair — Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels.
 * + ListPlaybackKeyPairs — Gets summary information about playback key pairs.
 * + DeletePlaybackKeyPair — Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`.
 *
 * **RecordingConfiguration Endpoints**
 * + CreateRecordingConfiguration — Creates a new recording configuration, used to enable recording to Amazon S3.
 * + GetRecordingConfiguration — Gets the recording-configuration metadata for the specified ARN.
 * + ListRecordingConfigurations — Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
 * + DeleteRecordingConfiguration — Deletes the recording configuration for the specified ARN.
 *
 * **Amazon Web Services Tags Endpoints**
 * + TagResource — Adds or updates tags for the Amazon Web Services resource with the specified ARN.
 * + UntagResource — Removes tags from the resource with the specified ARN.
 * + ListTagsForResource — Gets information about Amazon Web Services tags for the specified ARN.
 */
interface IvsClient : SdkClient {

    override val serviceName: String
        get() = "ivs"
    /**
     * IvsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IvsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIvsClient(config)
        }

        operator fun invoke(config: Config): IvsClient = DefaultIvsClient(config)

        /**
         * Construct a [IvsClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IvsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIvsClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Performs GetChannel on multiple ARNs simultaneously.
     */
    suspend fun batchGetChannel(input: BatchGetChannelRequest): BatchGetChannelResponse

    /**
     * Performs GetChannel on multiple ARNs simultaneously.
     */
    suspend fun batchGetChannel(block: BatchGetChannelRequest.Builder.() -> Unit) = batchGetChannel(BatchGetChannelRequest.Builder().apply(block).build())

    /**
     * Performs GetStreamKey on multiple ARNs simultaneously.
     */
    suspend fun batchGetStreamKey(input: BatchGetStreamKeyRequest): BatchGetStreamKeyResponse

    /**
     * Performs GetStreamKey on multiple ARNs simultaneously.
     */
    suspend fun batchGetStreamKey(block: BatchGetStreamKeyRequest.Builder.() -> Unit) = batchGetStreamKey(BatchGetStreamKeyRequest.Builder().apply(block).build())

    /**
     * Creates a new channel and an associated stream key to start streaming.
     */
    suspend fun createChannel(input: CreateChannelRequest = CreateChannelRequest {}): CreateChannelResponse

    /**
     * Creates a new channel and an associated stream key to start streaming.
     */
    suspend fun createChannel(block: CreateChannelRequest.Builder.() -> Unit) = createChannel(CreateChannelRequest.Builder().apply(block).build())

    /**
     * Creates a new recording configuration, used to enable recording to Amazon S3.
     *
     * **Known issue:** In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the `state` of the recording configuration is `CREATE_FAILED` (instead of `ACTIVE`). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
     *
     * **Workaround:** Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.
     */
    suspend fun createRecordingConfiguration(input: CreateRecordingConfigurationRequest): CreateRecordingConfigurationResponse

    /**
     * Creates a new recording configuration, used to enable recording to Amazon S3.
     *
     * **Known issue:** In the us-east-1 region, if you use the Amazon Web Services CLI to create a recording configuration, it returns success even if the S3 bucket is in a different region. In this case, the `state` of the recording configuration is `CREATE_FAILED` (instead of `ACTIVE`). (In other regions, the CLI correctly returns failure if the bucket is in a different region.)
     *
     * **Workaround:** Ensure that your S3 bucket is in the same region as the recording configuration. If you create a recording configuration in a different region as your S3 bucket, delete that recording configuration and create a new one with an S3 bucket from the correct region.
     */
    suspend fun createRecordingConfiguration(block: CreateRecordingConfigurationRequest.Builder.() -> Unit) = createRecordingConfiguration(CreateRecordingConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a stream key, used to initiate a stream, for the specified channel ARN.
     *
     * Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use DeleteStreamKey and then CreateStreamKey.
     */
    suspend fun createStreamKey(input: CreateStreamKeyRequest): CreateStreamKeyResponse

    /**
     * Creates a stream key, used to initiate a stream, for the specified channel ARN.
     *
     * Note that CreateChannel creates a stream key. If you subsequently use CreateStreamKey on the same channel, it will fail because a stream key already exists and there is a limit of 1 stream key per channel. To reset the stream key on a channel, use DeleteStreamKey and then CreateStreamKey.
     */
    suspend fun createStreamKey(block: CreateStreamKeyRequest.Builder.() -> Unit) = createStreamKey(CreateStreamKeyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified channel and its associated stream keys.
     *
     * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call StopStream, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See [ Using EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).)
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the specified channel and its associated stream keys.
     *
     * If you try to delete a live channel, you will get an error (409 ConflictException). To delete a channel that is live, call StopStream, wait for the Amazon EventBridge "Stream End" event (to verify that the stream's state was changed from Live to Offline), then call DeleteChannel. (See [ Using EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).)
     */
    suspend fun deleteChannel(block: DeleteChannelRequest.Builder.() -> Unit) = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

    /**
     * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun deletePlaybackKeyPair(input: DeletePlaybackKeyPairRequest): DeletePlaybackKeyPairResponse

    /**
     * Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun deletePlaybackKeyPair(block: DeletePlaybackKeyPairRequest.Builder.() -> Unit) = deletePlaybackKeyPair(DeletePlaybackKeyPairRequest.Builder().apply(block).build())

    /**
     * Deletes the recording configuration for the specified ARN.
     *
     * If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use UpdateChannel to set the `recordingConfigurationArn` field to an empty string, then use DeleteRecordingConfiguration.
     */
    suspend fun deleteRecordingConfiguration(input: DeleteRecordingConfigurationRequest): DeleteRecordingConfigurationResponse

    /**
     * Deletes the recording configuration for the specified ARN.
     *
     * If you try to delete a recording configuration that is associated with a channel, you will get an error (409 ConflictException). To avoid this, for all channels that reference the recording configuration, first use UpdateChannel to set the `recordingConfigurationArn` field to an empty string, then use DeleteRecordingConfiguration.
     */
    suspend fun deleteRecordingConfiguration(block: DeleteRecordingConfigurationRequest.Builder.() -> Unit) = deleteRecordingConfiguration(DeleteRecordingConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
     */
    suspend fun deleteStreamKey(input: DeleteStreamKeyRequest): DeleteStreamKeyResponse

    /**
     * Deletes the stream key for the specified ARN, so it can no longer be used to stream.
     */
    suspend fun deleteStreamKey(block: DeleteStreamKeyRequest.Builder.() -> Unit) = deleteStreamKey(DeleteStreamKeyRequest.Builder().apply(block).build())

    /**
     * Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
     */
    suspend fun getChannel(input: GetChannelRequest): GetChannelResponse

    /**
     * Gets the channel configuration for the specified channel ARN. See also BatchGetChannel.
     */
    suspend fun getChannel(block: GetChannelRequest.Builder.() -> Unit) = getChannel(GetChannelRequest.Builder().apply(block).build())

    /**
     * Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun getPlaybackKeyPair(input: GetPlaybackKeyPairRequest): GetPlaybackKeyPairResponse

    /**
     * Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun getPlaybackKeyPair(block: GetPlaybackKeyPairRequest.Builder.() -> Unit) = getPlaybackKeyPair(GetPlaybackKeyPairRequest.Builder().apply(block).build())

    /**
     * Gets the recording configuration for the specified ARN.
     */
    suspend fun getRecordingConfiguration(input: GetRecordingConfigurationRequest): GetRecordingConfigurationResponse

    /**
     * Gets the recording configuration for the specified ARN.
     */
    suspend fun getRecordingConfiguration(block: GetRecordingConfigurationRequest.Builder.() -> Unit) = getRecordingConfiguration(GetRecordingConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets information about the active (live) stream on a specified channel.
     */
    suspend fun getStream(input: GetStreamRequest): GetStreamResponse

    /**
     * Gets information about the active (live) stream on a specified channel.
     */
    suspend fun getStream(block: GetStreamRequest.Builder.() -> Unit) = getStream(GetStreamRequest.Builder().apply(block).build())

    /**
     * Gets stream-key information for a specified ARN.
     */
    suspend fun getStreamKey(input: GetStreamKeyRequest): GetStreamKeyResponse

    /**
     * Gets stream-key information for a specified ARN.
     */
    suspend fun getStreamKey(block: GetStreamKeyRequest.Builder.() -> Unit) = getStreamKey(GetStreamKeyRequest.Builder().apply(block).build())

    /**
     * Gets metadata on a specified stream.
     */
    suspend fun getStreamSession(input: GetStreamSessionRequest): GetStreamSessionResponse

    /**
     * Gets metadata on a specified stream.
     */
    suspend fun getStreamSession(block: GetStreamSessionRequest.Builder.() -> Unit) = getStreamSession(GetStreamSessionRequest.Builder().apply(block).build())

    /**
     * Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun importPlaybackKeyPair(input: ImportPlaybackKeyPairRequest): ImportPlaybackKeyPairResponse

    /**
     * Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun importPlaybackKeyPair(block: ImportPlaybackKeyPairRequest.Builder.() -> Unit) = importPlaybackKeyPair(ImportPlaybackKeyPairRequest.Builder().apply(block).build())

    /**
     * Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
     */
    suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
     */
    suspend fun listChannels(block: ListChannelsRequest.Builder.() -> Unit) = listChannels(ListChannelsRequest.Builder().apply(block).build())

    /**
     * Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun listPlaybackKeyPairs(input: ListPlaybackKeyPairsRequest = ListPlaybackKeyPairsRequest {}): ListPlaybackKeyPairsResponse

    /**
     * Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html) in the *Amazon IVS User Guide*.
     */
    suspend fun listPlaybackKeyPairs(block: ListPlaybackKeyPairsRequest.Builder.() -> Unit) = listPlaybackKeyPairs(ListPlaybackKeyPairsRequest.Builder().apply(block).build())

    /**
     * Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
     */
    suspend fun listRecordingConfigurations(input: ListRecordingConfigurationsRequest = ListRecordingConfigurationsRequest {}): ListRecordingConfigurationsResponse

    /**
     * Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
     */
    suspend fun listRecordingConfigurations(block: ListRecordingConfigurationsRequest.Builder.() -> Unit) = listRecordingConfigurations(ListRecordingConfigurationsRequest.Builder().apply(block).build())

    /**
     * Gets summary information about stream keys for the specified channel.
     */
    suspend fun listStreamKeys(input: ListStreamKeysRequest): ListStreamKeysResponse

    /**
     * Gets summary information about stream keys for the specified channel.
     */
    suspend fun listStreamKeys(block: ListStreamKeysRequest.Builder.() -> Unit) = listStreamKeys(ListStreamKeysRequest.Builder().apply(block).build())

    /**
     * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
     */
    suspend fun listStreamSessions(input: ListStreamSessionsRequest): ListStreamSessionsResponse

    /**
     * Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
     */
    suspend fun listStreamSessions(block: ListStreamSessionsRequest.Builder.() -> Unit) = listStreamSessions(ListStreamSessionsRequest.Builder().apply(block).build())

    /**
     * Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
     */
    suspend fun listStreams(input: ListStreamsRequest = ListStreamsRequest {}): ListStreamsResponse

    /**
     * Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
     */
    suspend fun listStreams(block: ListStreamsRequest.Builder.() -> Unit) = listStreams(ListStreamsRequest.Builder().apply(block).build())

    /**
     * Gets information about Amazon Web Services tags for the specified ARN.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets information about Amazon Web Services tags for the specified ARN.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html) in the *Amazon IVS User Guide*.
     */
    suspend fun putMetadata(input: PutMetadataRequest): PutMetadataResponse

    /**
     * Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/userguide/metadata.html) in the *Amazon IVS User Guide*.
     */
    suspend fun putMetadata(block: PutMetadataRequest.Builder.() -> Unit) = putMetadata(PutMetadataRequest.Builder().apply(block).build())

    /**
     * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
     *
     * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the `streamKey` attached to the channel.
     */
    suspend fun stopStream(input: StopStreamRequest): StopStreamResponse

    /**
     * Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with DeleteStreamKey to prevent further streaming to a channel.
     *
     * Many streaming client-software libraries automatically reconnect a dropped RTMPS session, so to stop the stream permanently, you may want to first revoke the `streamKey` attached to the channel.
     */
    suspend fun stopStream(block: StopStreamRequest.Builder.() -> Unit) = stopStream(StopStreamRequest.Builder().apply(block).build())

    /**
     * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates tags for the Amazon Web Services resource with the specified ARN.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from the resource with the specified ARN.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates a channel's configuration. This does not affect an ongoing stream of this channel. You must stop and restart the stream for the changes to take effect.
     */
    suspend fun updateChannel(block: UpdateChannelRequest.Builder.() -> Unit) = updateChannel(UpdateChannelRequest.Builder().apply(block).build())
}
