// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object that captures the Amazon IVS configuration that the customer provisioned, the ingest configurations that the broadcaster used, and the most recent Amazon IVS stream events it encountered.
 */
class StreamSession private constructor(builder: Builder) {
    /**
     * The properties of the channel at the time of going live.
     */
    val channel: aws.sdk.kotlin.services.ivs.model.Channel? = builder.channel
    /**
     * UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is `NULL`.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The properties of the incoming RTMP stream for the stream.
     */
    val ingestConfiguration: aws.sdk.kotlin.services.ivs.model.IngestConfiguration? = builder.ingestConfiguration
    /**
     * The properties of recording the live stream.
     */
    val recordingConfiguration: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration? = builder.recordingConfiguration
    /**
     * UTC ISO-8601 formatted timestamp of when the channel went live.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Unique identifier for a live or previously live stream in the specified channel.
     */
    val streamId: kotlin.String? = builder.streamId
    /**
     * List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see [Using Amazon EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
     */
    val truncatedEvents: List<StreamEvent>? = builder.truncatedEvents

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.StreamSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamSession(")
        append("channel=$channel,")
        append("endTime=$endTime,")
        append("ingestConfiguration=$ingestConfiguration,")
        append("recordingConfiguration=$recordingConfiguration,")
        append("startTime=$startTime,")
        append("streamId=$streamId,")
        append("truncatedEvents=$truncatedEvents)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channel?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (ingestConfiguration?.hashCode() ?: 0)
        result = 31 * result + (recordingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (truncatedEvents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamSession

        if (channel != other.channel) return false
        if (endTime != other.endTime) return false
        if (ingestConfiguration != other.ingestConfiguration) return false
        if (recordingConfiguration != other.recordingConfiguration) return false
        if (startTime != other.startTime) return false
        if (streamId != other.streamId) return false
        if (truncatedEvents != other.truncatedEvents) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.StreamSession = Builder(this).apply(block).build()

    class Builder {
        /**
         * The properties of the channel at the time of going live.
         */
        var channel: aws.sdk.kotlin.services.ivs.model.Channel? = null
        /**
         * UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is `NULL`.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The properties of the incoming RTMP stream for the stream.
         */
        var ingestConfiguration: aws.sdk.kotlin.services.ivs.model.IngestConfiguration? = null
        /**
         * The properties of recording the live stream.
         */
        var recordingConfiguration: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration? = null
        /**
         * UTC ISO-8601 formatted timestamp of when the channel went live.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for a live or previously live stream in the specified channel.
         */
        var streamId: kotlin.String? = null
        /**
         * List of Amazon IVS events that the stream encountered. The list is sorted by most recent events and contains up to 500 events. For Amazon IVS events, see [Using Amazon EventBridge with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
         */
        var truncatedEvents: List<StreamEvent>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.StreamSession) : this() {
            this.channel = x.channel
            this.endTime = x.endTime
            this.ingestConfiguration = x.ingestConfiguration
            this.recordingConfiguration = x.recordingConfiguration
            this.startTime = x.startTime
            this.streamId = x.streamId
            this.truncatedEvents = x.truncatedEvents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.StreamSession = StreamSession(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.Channel] inside the given [block]
         */
        fun channel(block: aws.sdk.kotlin.services.ivs.model.Channel.Builder.() -> kotlin.Unit) {
            this.channel = aws.sdk.kotlin.services.ivs.model.Channel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.IngestConfiguration] inside the given [block]
         */
        fun ingestConfiguration(block: aws.sdk.kotlin.services.ivs.model.IngestConfiguration.Builder.() -> kotlin.Unit) {
            this.ingestConfiguration = aws.sdk.kotlin.services.ivs.model.IngestConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivs.model.RecordingConfiguration] inside the given [block]
         */
        fun recordingConfiguration(block: aws.sdk.kotlin.services.ivs.model.RecordingConfiguration.Builder.() -> kotlin.Unit) {
            this.recordingConfiguration = aws.sdk.kotlin.services.ivs.model.RecordingConfiguration.invoke(block)
        }
    }
}
