// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a stream session.
 */
class StreamSessionSummary private constructor(builder: Builder) {
    /**
     * UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is `NULL`.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * If `true`, this stream encountered a quota breach or failure.
     */
    val hasErrorEvent: kotlin.Boolean = builder.hasErrorEvent
    /**
     * UTC ISO-8601 formatted timestamp of when the channel went live.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Unique identifier for a live or previously live stream in the specified channel.
     */
    val streamId: kotlin.String? = builder.streamId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivs.model.StreamSessionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamSessionSummary(")
        append("endTime=$endTime,")
        append("hasErrorEvent=$hasErrorEvent,")
        append("startTime=$startTime,")
        append("streamId=$streamId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (hasErrorEvent.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamSessionSummary

        if (endTime != other.endTime) return false
        if (hasErrorEvent != other.hasErrorEvent) return false
        if (startTime != other.startTime) return false
        if (streamId != other.streamId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivs.model.StreamSessionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * UTC ISO-8601 formatted timestamp of when the channel went offline. For live streams, this is `NULL`.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `true`, this stream encountered a quota breach or failure.
         */
        var hasErrorEvent: kotlin.Boolean = false
        /**
         * UTC ISO-8601 formatted timestamp of when the channel went live.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for a live or previously live stream in the specified channel.
         */
        var streamId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivs.model.StreamSessionSummary) : this() {
            this.endTime = x.endTime
            this.hasErrorEvent = x.hasErrorEvent
            this.startTime = x.startTime
            this.streamId = x.streamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivs.model.StreamSessionSummary = StreamSessionSummary(this)
    }
}
