// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ivs.model.IvsException
import aws.sdk.kotlin.services.ivs.model.ListPlaybackKeyPairsResponse
import aws.sdk.kotlin.services.ivs.model.PlaybackKeyPairSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListPlaybackKeyPairsOperationDeserializer: HttpDeserialize<ListPlaybackKeyPairsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListPlaybackKeyPairsResponse {
        if (!response.status.isSuccess()) {
            throwListPlaybackKeyPairsError(context, response)
        }
        val builder = ListPlaybackKeyPairsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListPlaybackKeyPairsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListPlaybackKeyPairsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPlaybackKeyPairsOperationBody(builder: ListPlaybackKeyPairsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYPAIRS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("keyPairs"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYPAIRS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYPAIRS_DESCRIPTOR.index -> builder.keyPairs =
                    deserializer.deserializeList(KEYPAIRS_DESCRIPTOR) {
                        val col0 = mutableListOf<PlaybackKeyPairSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePlaybackKeyPairSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
