// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.paginators

import aws.sdk.kotlin.services.ivschat.IvschatClient
import aws.sdk.kotlin.services.ivschat.model.ListRoomsRequest
import aws.sdk.kotlin.services.ivschat.model.ListRoomsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListRoomsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoomsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomsResponse]
 */
fun IvschatClient.listRoomsPaginated(initialRequest: ListRoomsRequest): Flow<ListRoomsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoomsPaginated.listRooms(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRoomsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoomsResponse]
 */
fun IvschatClient.listRoomsPaginated(block: ListRoomsRequest.Builder.() -> Unit): Flow<ListRoomsResponse> =
    listRoomsPaginated(ListRoomsRequest.Builder().apply(block).build())
