// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ivschat.model.IvschatException
import aws.sdk.kotlin.services.ivschat.model.MessageReviewHandler
import aws.sdk.kotlin.services.ivschat.model.UpdateRoomResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRoomOperationDeserializer: HttpDeserialize<UpdateRoomResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRoomResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRoomError(context, response)
        }
        val builder = UpdateRoomResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRoomOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRoomError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvschatException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PendingVerification" -> PendingVerificationDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvschatException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRoomOperationBody(builder: UpdateRoomResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createTime"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val MAXIMUMMESSAGELENGTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maximumMessageLength"))
    val MAXIMUMMESSAGERATEPERSECOND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maximumMessageRatePerSecond"))
    val MESSAGEREVIEWHANDLER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("messageReviewHandler"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATETIME_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(MAXIMUMMESSAGELENGTH_DESCRIPTOR)
        field(MAXIMUMMESSAGERATEPERSECOND_DESCRIPTOR)
        field(MESSAGEREVIEWHANDLER_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                MAXIMUMMESSAGELENGTH_DESCRIPTOR.index -> builder.maximumMessageLength = deserializeInt()
                MAXIMUMMESSAGERATEPERSECOND_DESCRIPTOR.index -> builder.maximumMessageRatePerSecond = deserializeInt()
                MESSAGEREVIEWHANDLER_DESCRIPTOR.index -> builder.messageReviewHandler = deserializeMessageReviewHandlerDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
