// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ivschat.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ivschat.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * **Introduction**
 *
 * The Amazon IVS Chat control-plane API enables you to create and manage Amazon IVS Chat resources. You also need to integrate with the [ Amazon IVS Chat Messaging API](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html), to enable users to interact with chat rooms in real time.
 *
 * The API is an AWS regional service. For a list of supported regions and Amazon IVS Chat HTTPS service endpoints, see the Amazon IVS Chat information on the [Amazon IVS page](https://docs.aws.amazon.com/general/latest/gr/ivs.html) in the *AWS General Reference*.
 *
 * **Notes on terminology:**
 * + You create service applications using the Amazon IVS Chat API. We refer to these as *applications*.
 * + You create front-end client applications (browser and Android/iOS apps) using the Amazon IVS Chat Messaging API. We refer to these as *clients*.
 *
 * **Resources**
 *
 * The following resource is part of Amazon IVS Chat:
 * + **Room** — The central Amazon IVS Chat resource through which clients connect to and exchange chat messages. See the Room endpoints for more information.
 *
 * **API Access Security**
 *
 * Your Amazon IVS Chat applications (service applications and clients) must be authenticated and authorized to access Amazon IVS Chat resources. Note the differences between these concepts:
 * + *Authentication* is about verifying identity. Requests to the Amazon IVS Chat API must be signed to verify your identity.
 * + *Authorization* is about granting permissions. Your IAM roles need to have permissions for Amazon IVS Chat API requests.
 *
 * Users (viewers) connect to a room using secure access tokens that you create using the CreateChatToken endpoint through the AWS SDK. You call CreateChatToken for every user’s chat session, passing identity and authorization information about the user.
 *
 * **Signing API Requests**
 *
 * HTTP API requests must be signed with an AWS SigV4 signature using your AWS security credentials. The AWS Command Line Interface (CLI) and the AWS SDKs take care of signing the underlying API calls for you. However, if your application calls the Amazon IVS Chat HTTP API directly, it’s your responsibility to sign the requests.
 *
 * You generate a signature using valid AWS credentials for an IAM role that has permission to perform the requested action. For example, DeleteMessage requests must be made using an IAM role that has the `ivschat:DeleteMessage` permission.
 *
 * For more information:
 * + Authentication and generating signatures — See [Authenticating Requests (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html) in the *Amazon Web Services General Reference*.
 * + Managing Amazon IVS permissions — See [Identity and Access Management](https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html) on the Security page of the *Amazon IVS User Guide*.
 *
 * **Messaging Endpoints**
 * + DeleteMessage — Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 * + DisconnectUser — Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
 * + SendEvent — Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
 *
 * **Chat Token Endpoint**
 * + CreateChatToken — Creates an encrypted token that is used to establish an individual WebSocket connection to a room. The token is valid for one minute, and a connection (session) established with the token is valid for the specified duration.
 *
 * **Room Endpoints**
 * + CreateRoom — Creates a room that allows clients to connect and pass messages.
 * + DeleteRoom — Deletes the specified room.
 * + GetRoom — Gets the specified room.
 * + ListRooms — Gets summary information about all your rooms in the AWS region where the API request is processed.
 * + UpdateRoom — Updates a room’s configuration.
 *
 * **Tags Endpoints**
 * + ListTagsForResource — Gets information about AWS tags for the specified ARN.
 * + TagResource — Adds or updates tags for the AWS resource with the specified ARN.
 * + UntagResource — Removes tags from the resource with the specified ARN.
 *
 * All the above are HTTP operations. There is a separate *messaging* API for managing Chat resources; see the [ Amazon IVS Chat Messaging API Reference](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/chat-messaging-api.html).
 */
interface IvschatClient : SdkClient {

    override val serviceName: String
        get() = "ivschat"
    /**
     * IvschatClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IvschatClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIvschatClient(config)
        }

        operator fun invoke(config: Config): IvschatClient = DefaultIvschatClient(config)

        /**
         * Construct a [IvschatClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IvschatClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIvschatClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an encrypted token that is used to establish an individual WebSocket connection to a room. The token is valid for one minute, and a connection (session) established with the token is valid for the specified duration.
     *
     * Encryption keys are owned by Amazon IVS Chat and never used directly by your application.
     */
    suspend fun createChatToken(input: CreateChatTokenRequest): CreateChatTokenResponse

    /**
     * Creates an encrypted token that is used to establish an individual WebSocket connection to a room. The token is valid for one minute, and a connection (session) established with the token is valid for the specified duration.
     *
     * Encryption keys are owned by Amazon IVS Chat and never used directly by your application.
     */
    suspend fun createChatToken(block: CreateChatTokenRequest.Builder.() -> Unit) = createChatToken(CreateChatTokenRequest.Builder().apply(block).build())

    /**
     * Creates a room that allows clients to connect and pass messages.
     */
    suspend fun createRoom(input: CreateRoomRequest = CreateRoomRequest {}): CreateRoomResponse

    /**
     * Creates a room that allows clients to connect and pass messages.
     */
    suspend fun createRoom(block: CreateRoomRequest.Builder.() -> Unit) = createRoom(CreateRoomRequest.Builder().apply(block).build())

    /**
     * Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    suspend fun deleteMessage(input: DeleteMessageRequest): DeleteMessageResponse

    /**
     * Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [ DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    suspend fun deleteMessage(block: DeleteMessageRequest.Builder.() -> Unit) = deleteMessage(DeleteMessageRequest.Builder().apply(block).build())

    /**
     * Deletes the specified room.
     */
    suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse

    /**
     * Deletes the specified room.
     */
    suspend fun deleteRoom(block: DeleteRoomRequest.Builder.() -> Unit) = deleteRoom(DeleteRoomRequest.Builder().apply(block).build())

    /**
     * Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    suspend fun disconnectUser(input: DisconnectUserRequest): DisconnectUserResponse

    /**
     * Disconnects all connections using a specified user ID from a room. This replicates the [ DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
     */
    suspend fun disconnectUser(block: DisconnectUserRequest.Builder.() -> Unit) = disconnectUser(DisconnectUserRequest.Builder().apply(block).build())

    /**
     * Gets the specified room.
     */
    suspend fun getRoom(input: GetRoomRequest): GetRoomResponse

    /**
     * Gets the specified room.
     */
    suspend fun getRoom(block: GetRoomRequest.Builder.() -> Unit) = getRoom(GetRoomRequest.Builder().apply(block).build())

    /**
     * Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of `updateTime`.
     */
    suspend fun listRooms(input: ListRoomsRequest = ListRoomsRequest {}): ListRoomsResponse

    /**
     * Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of `updateTime`.
     */
    suspend fun listRooms(block: ListRoomsRequest.Builder.() -> Unit) = listRooms(ListRoomsRequest.Builder().apply(block).build())

    /**
     * Gets information about AWS tags for the specified ARN.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets information about AWS tags for the specified ARN.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
     */
    suspend fun sendEvent(input: SendEventRequest): SendEventResponse

    /**
     * Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
     */
    suspend fun sendEvent(block: SendEventRequest.Builder.() -> Unit) = sendEvent(SendEventRequest.Builder().apply(block).build())

    /**
     * Adds or updates tags for the AWS resource with the specified ARN.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or updates tags for the AWS resource with the specified ARN.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from the resource with the specified ARN.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a room’s configuration.
     */
    suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse

    /**
     * Updates a room’s configuration.
     */
    suspend fun updateRoom(block: UpdateRoomRequest.Builder.() -> Unit) = updateRoom(UpdateRoomRequest.Builder().apply(block).build())
}
