// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivschat.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ivschat.model.CreateChatTokenResponse
import aws.sdk.kotlin.services.ivschat.model.IvschatException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateChatTokenOperationDeserializer: HttpDeserialize<CreateChatTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateChatTokenResponse {
        if (!response.status.isSuccess()) {
            throwCreateChatTokenError(context, response)
        }
        val builder = CreateChatTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateChatTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateChatTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvschatException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PendingVerification" -> PendingVerificationDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvschatException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateChatTokenOperationBody(builder: CreateChatTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SESSIONEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("sessionExpirationTime"))
    val TOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("token"))
    val TOKENEXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("tokenExpirationTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SESSIONEXPIRATIONTIME_DESCRIPTOR)
        field(TOKEN_DESCRIPTOR)
        field(TOKENEXPIRATIONTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SESSIONEXPIRATIONTIME_DESCRIPTOR.index -> builder.sessionExpirationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TOKEN_DESCRIPTOR.index -> builder.token = deserializeString()
                TOKENEXPIRATIONTIME_DESCRIPTOR.index -> builder.tokenExpirationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
