// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.kafka.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kafka.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The operations for managing an Amazon MSK cluster.
 */
interface KafkaClient : SdkClient {

    override val serviceName: String
        get() = "Kafka"
    /**
     * KafkaClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): KafkaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKafkaClient(config)
        }

        operator fun invoke(config: Config): KafkaClient = DefaultKafkaClient(config)

        /**
         * Construct a [KafkaClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KafkaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultKafkaClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    suspend fun batchAssociateScramSecret(block: BatchAssociateScramSecretRequest.Builder.() -> Unit) = batchAssociateScramSecret(BatchAssociateScramSecretRequest.Builder().apply(block).build())

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    suspend fun batchDisassociateScramSecret(block: BatchDisassociateScramSecretRequest.Builder.() -> Unit) = batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.Builder().apply(block).build())

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createCluster(block: CreateClusterRequest.Builder.() -> Unit) = createCluster(CreateClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createClusterV2(input: CreateClusterV2Request): CreateClusterV2Response

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createClusterV2(block: CreateClusterV2Request.Builder.() -> Unit) = createClusterV2(CreateClusterV2Request.Builder().apply(block).build())

    /**
     * Creates a new MSK configuration.
     */
    suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Creates a new MSK configuration.
     */
    suspend fun createConfiguration(block: CreateConfigurationRequest.Builder.() -> Unit) = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    suspend fun deleteCluster(block: DeleteClusterRequest.Builder.() -> Unit) = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

    /**
     * Deletes an MSK Configuration.
     */
    suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse

    /**
     * Deletes an MSK Configuration.
     */
    suspend fun deleteConfiguration(block: DeleteConfigurationRequest.Builder.() -> Unit) = deleteConfiguration(DeleteConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeCluster(block: DescribeClusterRequest.Builder.() -> Unit) = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    suspend fun describeClusterOperation(block: DescribeClusterOperationRequest.Builder.() -> Unit) = describeClusterOperation(DescribeClusterOperationRequest.Builder().apply(block).build())

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeClusterV2(input: DescribeClusterV2Request): DescribeClusterV2Response

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeClusterV2(block: DescribeClusterV2Request.Builder.() -> Unit) = describeClusterV2(DescribeClusterV2Request.Builder().apply(block).build())

    /**
     * Returns a description of this MSK configuration.
     */
    suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns a description of this MSK configuration.
     */
    suspend fun describeConfiguration(block: DescribeConfigurationRequest.Builder.() -> Unit) = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns a description of this revision of the configuration.
     */
    suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * Returns a description of this revision of the configuration.
     */
    suspend fun describeConfigurationRevision(block: DescribeConfigurationRevisionRequest.Builder.() -> Unit) = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    suspend fun getBootstrapBrokers(block: GetBootstrapBrokersRequest.Builder.() -> Unit) = getBootstrapBrokers(GetBootstrapBrokersRequest.Builder().apply(block).build())

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest = GetCompatibleKafkaVersionsRequest {}): GetCompatibleKafkaVersionsResponse

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    suspend fun getCompatibleKafkaVersions(block: GetCompatibleKafkaVersionsRequest.Builder.() -> Unit) = getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    suspend fun listClusterOperations(block: ListClusterOperationsRequest.Builder.() -> Unit) = listClusterOperations(ListClusterOperationsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClusters(block: ListClustersRequest.Builder.() -> Unit) = listClusters(ListClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClustersV2(input: ListClustersV2Request = ListClustersV2Request {}): ListClustersV2Response

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClustersV2(block: ListClustersV2Request.Builder.() -> Unit) = listClustersV2(ListClustersV2Request.Builder().apply(block).build())

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurationRevisions(block: ListConfigurationRevisionsRequest.Builder.() -> Unit) = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurations(input: ListConfigurationsRequest = ListConfigurationsRequest {}): ListConfigurationsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurations(block: ListConfigurationsRequest.Builder.() -> Unit) = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

    /**
     * Returns a list of Apache Kafka versions.
     */
    suspend fun listKafkaVersions(input: ListKafkaVersionsRequest = ListKafkaVersionsRequest {}): ListKafkaVersionsResponse

    /**
     * Returns a list of Apache Kafka versions.
     */
    suspend fun listKafkaVersions(block: ListKafkaVersionsRequest.Builder.() -> Unit) = listKafkaVersions(ListKafkaVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    suspend fun listNodes(block: ListNodesRequest.Builder.() -> Unit) = listNodes(ListNodesRequest.Builder().apply(block).build())

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    suspend fun listScramSecrets(block: ListScramSecretsRequest.Builder.() -> Unit) = listScramSecrets(ListScramSecretsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Reboots brokers.
     */
    suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Reboots brokers.
     */
    suspend fun rebootBroker(block: RebootBrokerRequest.Builder.() -> Unit) = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

    /**
     * Adds tags to the specified MSK resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to the specified MSK resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the number of broker nodes in the cluster.
     */
    suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse

    /**
     * Updates the number of broker nodes in the cluster.
     */
    suspend fun updateBrokerCount(block: UpdateBrokerCountRequest.Builder.() -> Unit) = updateBrokerCount(UpdateBrokerCountRequest.Builder().apply(block).build())

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    suspend fun updateBrokerStorage(block: UpdateBrokerStorageRequest.Builder.() -> Unit) = updateBrokerStorage(UpdateBrokerStorageRequest.Builder().apply(block).build())

    /**
     * Updates EC2 instance type.
     */
    suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse

    /**
     * Updates EC2 instance type.
     */
    suspend fun updateBrokerType(block: UpdateBrokerTypeRequest.Builder.() -> Unit) = updateBrokerType(UpdateBrokerTypeRequest.Builder().apply(block).build())

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    suspend fun updateClusterConfiguration(block: UpdateClusterConfigurationRequest.Builder.() -> Unit) = updateClusterConfiguration(UpdateClusterConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    suspend fun updateClusterKafkaVersion(block: UpdateClusterKafkaVersionRequest.Builder.() -> Unit) = updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.Builder().apply(block).build())

    /**
     * Updates an MSK configuration.
     */
    suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates an MSK configuration.
     */
    suspend fun updateConfiguration(block: UpdateConfigurationRequest.Builder.() -> Unit) = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the cluster's connectivity configuration.
     */
    suspend fun updateConnectivity(input: UpdateConnectivityRequest): UpdateConnectivityResponse

    /**
     * Updates the cluster's connectivity configuration.
     */
    suspend fun updateConnectivity(block: UpdateConnectivityRequest.Builder.() -> Unit) = updateConnectivity(UpdateConnectivityRequest.Builder().apply(block).build())

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    suspend fun updateMonitoring(block: UpdateMonitoringRequest.Builder.() -> Unit) = updateMonitoring(UpdateMonitoringRequest.Builder().apply(block).build())

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    suspend fun updateSecurity(block: UpdateSecurityRequest.Builder.() -> Unit) = updateSecurity(UpdateSecurityRequest.Builder().apply(block).build())
}
