// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Describes the setup to be used for Apache Kafka broker nodes in the cluster.
 */
class BrokerNodeGroupInfo private constructor(builder: Builder) {
    /**
     * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
     *
     * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
     */
    val brokerAzDistribution: aws.sdk.kotlin.services.kafka.model.BrokerAzDistribution? = builder.brokerAzDistribution
    /**
     * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't be in Availability Zone us-east-1e.
     */
    val clientSubnets: List<String>? = builder.clientSubnets
    /**
     * Information about the broker access configuration.
     */
    val connectivityInfo: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo? = builder.connectivityInfo
    /**
     * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * Contains information about storage volumes attached to MSK broker nodes.
     */
    val storageInfo: aws.sdk.kotlin.services.kafka.model.StorageInfo? = builder.storageInfo

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BrokerNodeGroupInfo(")
        append("brokerAzDistribution=$brokerAzDistribution,")
        append("clientSubnets=$clientSubnets,")
        append("connectivityInfo=$connectivityInfo,")
        append("instanceType=$instanceType,")
        append("securityGroups=$securityGroups,")
        append("storageInfo=$storageInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerAzDistribution?.hashCode() ?: 0
        result = 31 * result + (clientSubnets?.hashCode() ?: 0)
        result = 31 * result + (connectivityInfo?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BrokerNodeGroupInfo

        if (brokerAzDistribution != other.brokerAzDistribution) return false
        if (clientSubnets != other.clientSubnets) return false
        if (connectivityInfo != other.connectivityInfo) return false
        if (instanceType != other.instanceType) return false
        if (securityGroups != other.securityGroups) return false
        if (storageInfo != other.storageInfo) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
         *
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
         */
        var brokerAzDistribution: aws.sdk.kotlin.services.kafka.model.BrokerAzDistribution? = null
        /**
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't be in Availability Zone us-east-1e.
         */
        var clientSubnets: List<String>? = null
        /**
         * Information about the broker access configuration.
         */
        var connectivityInfo: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo? = null
        /**
         * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
         */
        var instanceType: kotlin.String? = null
        /**
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
         */
        var securityGroups: List<String>? = null
        /**
         * Contains information about storage volumes attached to MSK broker nodes.
         */
        var storageInfo: aws.sdk.kotlin.services.kafka.model.StorageInfo? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo) : this() {
            this.brokerAzDistribution = x.brokerAzDistribution
            this.clientSubnets = x.clientSubnets
            this.connectivityInfo = x.connectivityInfo
            this.instanceType = x.instanceType
            this.securityGroups = x.securityGroups
            this.storageInfo = x.storageInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = BrokerNodeGroupInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConnectivityInfo] inside the given [block]
         */
        fun connectivityInfo(block: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo.Builder.() -> kotlin.Unit) {
            this.connectivityInfo = aws.sdk.kotlin.services.kafka.model.ConnectivityInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StorageInfo] inside the given [block]
         */
        fun storageInfo(block: aws.sdk.kotlin.services.kafka.model.StorageInfo.Builder.() -> kotlin.Unit) {
            this.storageInfo = aws.sdk.kotlin.services.kafka.model.StorageInfo.invoke(block)
        }
    }
}
