// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster.
 */
class Cluster private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
     */
    val activeOperationArn: kotlin.String? = builder.activeOperationArn
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The name of the cluster.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * Cluster Type.
     */
    val clusterType: aws.sdk.kotlin.services.kafka.model.ClusterType? = builder.clusterType
    /**
     * The time when the cluster was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The current version of the MSK cluster.
     */
    val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Information about the provisioned cluster.
     */
    val provisioned: aws.sdk.kotlin.services.kafka.model.Provisioned? = builder.provisioned
    /**
     * Information about the serverless cluster.
     */
    val serverless: aws.sdk.kotlin.services.kafka.model.Serverless? = builder.serverless
    /**
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     */
    val state: aws.sdk.kotlin.services.kafka.model.ClusterState? = builder.state
    /**
     * State Info for the Amazon MSK cluster.
     */
    val stateInfo: aws.sdk.kotlin.services.kafka.model.StateInfo? = builder.stateInfo
    /**
     * Tags attached to the cluster.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("activeOperationArn=$activeOperationArn,")
        append("clusterArn=$clusterArn,")
        append("clusterName=$clusterName,")
        append("clusterType=$clusterType,")
        append("creationTime=$creationTime,")
        append("currentVersion=$currentVersion,")
        append("provisioned=$provisioned,")
        append("serverless=$serverless,")
        append("state=$state,")
        append("stateInfo=$stateInfo,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeOperationArn?.hashCode() ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (provisioned?.hashCode() ?: 0)
        result = 31 * result + (serverless?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateInfo?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (activeOperationArn != other.activeOperationArn) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterName != other.clusterName) return false
        if (clusterType != other.clusterType) return false
        if (creationTime != other.creationTime) return false
        if (currentVersion != other.currentVersion) return false
        if (provisioned != other.provisioned) return false
        if (serverless != other.serverless) return false
        if (state != other.state) return false
        if (stateInfo != other.stateInfo) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.Cluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
         */
        var activeOperationArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        var clusterArn: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        var clusterName: kotlin.String? = null
        /**
         * Cluster Type.
         */
        var clusterType: aws.sdk.kotlin.services.kafka.model.ClusterType? = null
        /**
         * The time when the cluster was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current version of the MSK cluster.
         */
        var currentVersion: kotlin.String? = null
        /**
         * Information about the provisioned cluster.
         */
        var provisioned: aws.sdk.kotlin.services.kafka.model.Provisioned? = null
        /**
         * Information about the serverless cluster.
         */
        var serverless: aws.sdk.kotlin.services.kafka.model.Serverless? = null
        /**
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         */
        var state: aws.sdk.kotlin.services.kafka.model.ClusterState? = null
        /**
         * State Info for the Amazon MSK cluster.
         */
        var stateInfo: aws.sdk.kotlin.services.kafka.model.StateInfo? = null
        /**
         * Tags attached to the cluster.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.Cluster) : this() {
            this.activeOperationArn = x.activeOperationArn
            this.clusterArn = x.clusterArn
            this.clusterName = x.clusterName
            this.clusterType = x.clusterType
            this.creationTime = x.creationTime
            this.currentVersion = x.currentVersion
            this.provisioned = x.provisioned
            this.serverless = x.serverless
            this.state = x.state
            this.stateInfo = x.stateInfo
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.Provisioned] inside the given [block]
         */
        fun provisioned(block: aws.sdk.kotlin.services.kafka.model.Provisioned.Builder.() -> kotlin.Unit) {
            this.provisioned = aws.sdk.kotlin.services.kafka.model.Provisioned.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.Serverless] inside the given [block]
         */
        fun serverless(block: aws.sdk.kotlin.services.kafka.model.Serverless.Builder.() -> kotlin.Unit) {
            this.serverless = aws.sdk.kotlin.services.kafka.model.Serverless.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StateInfo] inside the given [block]
         */
        fun stateInfo(block: aws.sdk.kotlin.services.kafka.model.StateInfo.Builder.() -> kotlin.Unit) {
            this.stateInfo = aws.sdk.kotlin.services.kafka.model.StateInfo.invoke(block)
        }
    }
}
