// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * The settings for encrypting data in transit.
 */
class EncryptionInTransit private constructor(builder: Builder) {
    /**
     * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
     *
     *  TLS means that client-broker communication is enabled with TLS only.
     *
     *  TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
     *
     *  PLAINTEXT means that client-broker communication is enabled in plaintext only.
     *
     * The default value is TLS_PLAINTEXT.
     */
    val clientBroker: aws.sdk.kotlin.services.kafka.model.ClientBroker? = builder.clientBroker
    /**
     * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
     *
     * The default value is true.
     */
    val inCluster: kotlin.Boolean? = builder.inCluster

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.EncryptionInTransit = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionInTransit(")
        append("clientBroker=$clientBroker,")
        append("inCluster=$inCluster)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientBroker?.hashCode() ?: 0
        result = 31 * result + (inCluster?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionInTransit

        if (clientBroker != other.clientBroker) return false
        if (inCluster != other.inCluster) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.EncryptionInTransit = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
         *
         *  TLS means that client-broker communication is enabled with TLS only.
         *
         *  TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
         *
         *  PLAINTEXT means that client-broker communication is enabled in plaintext only.
         *
         * The default value is TLS_PLAINTEXT.
         */
        var clientBroker: aws.sdk.kotlin.services.kafka.model.ClientBroker? = null
        /**
         * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
         *
         * The default value is true.
         */
        var inCluster: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.EncryptionInTransit) : this() {
            this.clientBroker = x.clientBroker
            this.inCluster = x.inCluster
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.EncryptionInTransit = EncryptionInTransit(this)
    }
}
