// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



class UntagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.
     */
    val resourceArn: kotlin.String? = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Tag keys must be unique for a given cluster. In addition, the following restrictions apply:
     * + Each tag key must be unique. If you add a tag with a key that's already in use, your new tag overwrites the existing key-value pair.
     * + You can't start a tag key with aws: because this prefix is reserved for use by AWS. AWS creates tags that begin with this prefix on your behalf, but you can't edit or delete them.
     * + Tag keys must be between 1 and 128 Unicode characters in length.
     * + Tag keys must consist of the following characters: Unicode letters, digits, white space, and the following special characters: _ . / = + - @.
     */
    val tagKeys: List<String>? = builder.tagKeys

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.UntagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UntagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tagKeys=$tagKeys)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UntagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.UntagResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the resource that's associated with the tags.
         */
        var resourceArn: kotlin.String? = null
        /**
         * Tag keys must be unique for a given cluster. In addition, the following restrictions apply:
         * + Each tag key must be unique. If you add a tag with a key that's already in use, your new tag overwrites the existing key-value pair.
         * + You can't start a tag key with aws: because this prefix is reserved for use by AWS. AWS creates tags that begin with this prefix on your behalf, but you can't edit or delete them.
         * + Tag keys must be between 1 and 128 Unicode characters in length.
         * + Tag keys must consist of the following characters: Unicode letters, digits, white space, and the following special characters: _ . / = + - @.
         */
        var tagKeys: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.UntagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.UntagResourceRequest = UntagResourceRequest(this)
    }
}
