// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Request body for UpdateMonitoring.
 */
class UpdateMonitoringRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    val clusterArn: kotlin.String? = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.
     */
    val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     */
    val enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = builder.enhancedMonitoring
    val loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = builder.loggingInfo
    /**
     * The settings for open monitoring.
     */
    val openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo? = builder.openMonitoring

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMonitoringRequest(")
        append("clusterArn=$clusterArn,")
        append("currentVersion=$currentVersion,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("loggingInfo=$loggingInfo,")
        append("openMonitoring=$openMonitoring)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMonitoringRequest

        if (clusterArn != other.clusterArn) return false
        if (currentVersion != other.currentVersion) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (loggingInfo != other.loggingInfo) return false
        if (openMonitoring != other.openMonitoring) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        var clusterArn: kotlin.String? = null
        /**
         * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.
         */
        var currentVersion: kotlin.String? = null
        /**
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         */
        var enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = null
        var loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = null
        /**
         * The settings for open monitoring.
         */
        var openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest) : this() {
            this.clusterArn = x.clusterArn
            this.currentVersion = x.currentVersion
            this.enhancedMonitoring = x.enhancedMonitoring
            this.loggingInfo = x.loggingInfo
            this.openMonitoring = x.openMonitoring
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = UpdateMonitoringRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: aws.sdk.kotlin.services.kafka.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.kafka.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo] inside the given [block]
         */
        fun openMonitoring(block: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo.Builder.() -> kotlin.Unit) {
            this.openMonitoring = aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo.invoke(block)
        }
    }
}
