// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.paginators

import aws.sdk.kotlin.services.kafka.KafkaClient
import aws.sdk.kotlin.services.kafka.model.Cluster
import aws.sdk.kotlin.services.kafka.model.ClusterInfo
import aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo
import aws.sdk.kotlin.services.kafka.model.Configuration
import aws.sdk.kotlin.services.kafka.model.ConfigurationRevision
import aws.sdk.kotlin.services.kafka.model.KafkaVersion
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsRequest
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersRequest
import aws.sdk.kotlin.services.kafka.model.ListClustersResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Request
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Response
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListNodesRequest
import aws.sdk.kotlin.services.kafka.model.ListNodesResponse
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsRequest
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsResponse
import aws.sdk.kotlin.services.kafka.model.NodeInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListClusterOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClusterOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsResponse]
 */
fun KafkaClient.listClusterOperationsPaginated(initialRequest: ListClusterOperationsRequest): Flow<ListClusterOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClusterOperationsPaginated.listClusterOperations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClusterOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsResponse]
 */
fun KafkaClient.listClusterOperationsPaginated(block: ListClusterOperationsRequest.Builder.() -> Unit): Flow<ListClusterOperationsResponse> =
    listClusterOperationsPaginated(ListClusterOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClusterOperationsPaginated]
 * to access the nested member [ClusterOperationInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterOperationInfo]
 */
@JvmName("listClusterOperationsResponseClusterOperationInfo")
fun Flow<ListClusterOperationsResponse>.clusterOperationInfoList(): Flow<ClusterOperationInfo> =
    transform() { response ->
        response.clusterOperationInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun KafkaClient.listClustersPaginated(initialRequest: ListClustersRequest): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
fun KafkaClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [ClusterInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterInfo]
 */
@JvmName("listClustersResponseClusterInfo")
fun Flow<ListClustersResponse>.clusterInfoList(): Flow<ClusterInfo> =
    transform() { response ->
        response.clusterInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersV2Response]
 */
fun KafkaClient.listClustersV2Paginated(initialRequest: ListClustersV2Request): Flow<ListClustersV2Response> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersV2Paginated.listClustersV2(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersV2Response]
 */
fun KafkaClient.listClustersV2Paginated(block: ListClustersV2Request.Builder.() -> Unit): Flow<ListClustersV2Response> =
    listClustersV2Paginated(ListClustersV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersV2Paginated]
 * to access the nested member [Cluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Cluster]
 */
@JvmName("listClustersV2ResponseCluster")
fun Flow<ListClustersV2Response>.clusterInfoList(): Flow<Cluster> =
    transform() { response ->
        response.clusterInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationRevisionsResponse]
 */
fun KafkaClient.listConfigurationRevisionsPaginated(initialRequest: ListConfigurationRevisionsRequest): Flow<ListConfigurationRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationRevisionsPaginated.listConfigurationRevisions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationRevisionsResponse]
 */
fun KafkaClient.listConfigurationRevisionsPaginated(block: ListConfigurationRevisionsRequest.Builder.() -> Unit): Flow<ListConfigurationRevisionsResponse> =
    listConfigurationRevisionsPaginated(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationRevisionsPaginated]
 * to access the nested member [ConfigurationRevision]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationRevision]
 */
@JvmName("listConfigurationRevisionsResponseConfigurationRevision")
fun Flow<ListConfigurationRevisionsResponse>.revisions(): Flow<ConfigurationRevision> =
    transform() { response ->
        response.revisions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
fun KafkaClient.listConfigurationsPaginated(initialRequest: ListConfigurationsRequest): Flow<ListConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationsPaginated.listConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
fun KafkaClient.listConfigurationsPaginated(block: ListConfigurationsRequest.Builder.() -> Unit): Flow<ListConfigurationsResponse> =
    listConfigurationsPaginated(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationsPaginated]
 * to access the nested member [Configuration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Configuration]
 */
@JvmName("listConfigurationsResponseConfiguration")
fun Flow<ListConfigurationsResponse>.configurations(): Flow<Configuration> =
    transform() { response ->
        response.configurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKafkaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKafkaVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKafkaVersionsResponse]
 */
fun KafkaClient.listKafkaVersionsPaginated(initialRequest: ListKafkaVersionsRequest): Flow<ListKafkaVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKafkaVersionsPaginated.listKafkaVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListKafkaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKafkaVersionsResponse]
 */
fun KafkaClient.listKafkaVersionsPaginated(block: ListKafkaVersionsRequest.Builder.() -> Unit): Flow<ListKafkaVersionsResponse> =
    listKafkaVersionsPaginated(ListKafkaVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKafkaVersionsPaginated]
 * to access the nested member [KafkaVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KafkaVersion]
 */
@JvmName("listKafkaVersionsResponseKafkaVersion")
fun Flow<ListKafkaVersionsResponse>.kafkaVersions(): Flow<KafkaVersion> =
    transform() { response ->
        response.kafkaVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
fun KafkaClient.listNodesPaginated(initialRequest: ListNodesRequest): Flow<ListNodesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNodesPaginated.listNodes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
fun KafkaClient.listNodesPaginated(block: ListNodesRequest.Builder.() -> Unit): Flow<ListNodesResponse> =
    listNodesPaginated(ListNodesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNodesPaginated]
 * to access the nested member [NodeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NodeInfo]
 */
@JvmName("listNodesResponseNodeInfo")
fun Flow<ListNodesResponse>.nodeInfoList(): Flow<NodeInfo> =
    transform() { response ->
        response.nodeInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListScramSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScramSecretsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScramSecretsResponse]
 */
fun KafkaClient.listScramSecretsPaginated(initialRequest: ListScramSecretsRequest): Flow<ListScramSecretsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScramSecretsPaginated.listScramSecrets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListScramSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScramSecretsResponse]
 */
fun KafkaClient.listScramSecretsPaginated(block: ListScramSecretsRequest.Builder.() -> Unit): Flow<ListScramSecretsResponse> =
    listScramSecretsPaginated(ListScramSecretsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScramSecretsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listScramSecretsResponseString")
fun Flow<ListScramSecretsResponse>.secretArnList(): Flow<String> =
    transform() { response ->
        response.secretArnList?.forEach {
            emit(it)
        }
    }
