// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.kafka.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kafka.model.*
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterRequest
import aws.sdk.kotlin.services.kafka.model.CreateClusterResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Request
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Response
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DeleteClusterRequest
import aws.sdk.kotlin.services.kafka.model.DeleteClusterResponse
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Request
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Response
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersRequest
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsRequest
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersRequest
import aws.sdk.kotlin.services.kafka.model.ListClustersResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Request
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Response
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListNodesRequest
import aws.sdk.kotlin.services.kafka.model.ListNodesResponse
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsRequest
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsResponse
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kafka.model.RebootBrokerRequest
import aws.sdk.kotlin.services.kafka.model.RebootBrokerResponse
import aws.sdk.kotlin.services.kafka.model.TagResourceRequest
import aws.sdk.kotlin.services.kafka.model.TagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UntagResourceRequest
import aws.sdk.kotlin.services.kafka.model.UntagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringResponse
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateStorageResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The operations for managing an Amazon MSK cluster.
 */
public interface KafkaClient : SdkClient {

    override val serviceName: String
        get() = "Kafka"
    /**
     * KafkaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): KafkaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKafkaClient(config)
        }

        public operator fun invoke(config: Config): KafkaClient = DefaultKafkaClient(config)

        /**
         * Construct a [KafkaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KafkaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultKafkaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    public suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    public suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createClusterV2(input: CreateClusterV2Request): CreateClusterV2Response

    /**
     * Creates a new MSK configuration.
     */
    public suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes an MSK Configuration.
     */
    public suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    public suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeClusterV2(input: DescribeClusterV2Request): DescribeClusterV2Response

    /**
     * Returns a description of this MSK configuration.
     */
    public suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns a description of this revision of the configuration.
     */
    public suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    public suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    public suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest = GetCompatibleKafkaVersionsRequest {}): GetCompatibleKafkaVersionsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    public suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClustersV2(input: ListClustersV2Request = ListClustersV2Request {}): ListClustersV2Response

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest = ListConfigurationsRequest {}): ListConfigurationsResponse

    /**
     * Returns a list of Apache Kafka versions.
     */
    public suspend fun listKafkaVersions(input: ListKafkaVersionsRequest = ListKafkaVersionsRequest {}): ListKafkaVersionsResponse

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    public suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    public suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Reboots brokers.
     */
    public suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Adds tags to the specified MSK resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the number of broker nodes in the cluster.
     */
    public suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    public suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse

    /**
     * Updates EC2 instance type.
     */
    public suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    public suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    public suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse

    /**
     * Updates an MSK configuration.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates the cluster's connectivity configuration.
     */
    public suspend fun updateConnectivity(input: UpdateConnectivityRequest): UpdateConnectivityResponse

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    public suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    public suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
     */
    public suspend fun updateStorage(input: UpdateStorageRequest): UpdateStorageResponse
}

/**
 * Associates one or more Scram Secrets with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchAssociateScramSecret(crossinline block: BatchAssociateScramSecretRequest.Builder.() -> Unit): BatchAssociateScramSecretResponse = batchAssociateScramSecret(BatchAssociateScramSecretRequest.Builder().apply(block).build())

/**
 * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchDisassociateScramSecret(crossinline block: BatchDisassociateScramSecretRequest.Builder.() -> Unit): BatchDisassociateScramSecretResponse = batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createClusterV2(crossinline block: CreateClusterV2Request.Builder.() -> Unit): CreateClusterV2Response = createClusterV2(CreateClusterV2Request.Builder().apply(block).build())

/**
 * Creates a new MSK configuration.
 */
public suspend inline fun KafkaClient.createConfiguration(crossinline block: CreateConfigurationRequest.Builder.() -> Unit): CreateConfigurationResponse = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes an MSK Configuration.
 */
public suspend inline fun KafkaClient.deleteConfiguration(crossinline block: DeleteConfigurationRequest.Builder.() -> Unit): DeleteConfigurationResponse = deleteConfiguration(DeleteConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Returns a description of the cluster operation specified by the ARN.
 */
public suspend inline fun KafkaClient.describeClusterOperation(crossinline block: DescribeClusterOperationRequest.Builder.() -> Unit): DescribeClusterOperationResponse = describeClusterOperation(DescribeClusterOperationRequest.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeClusterV2(crossinline block: DescribeClusterV2Request.Builder.() -> Unit): DescribeClusterV2Response = describeClusterV2(DescribeClusterV2Request.Builder().apply(block).build())

/**
 * Returns a description of this MSK configuration.
 */
public suspend inline fun KafkaClient.describeConfiguration(crossinline block: DescribeConfigurationRequest.Builder.() -> Unit): DescribeConfigurationResponse = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of this revision of the configuration.
 */
public suspend inline fun KafkaClient.describeConfigurationRevision(crossinline block: DescribeConfigurationRevisionRequest.Builder.() -> Unit): DescribeConfigurationRevisionResponse = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

/**
 * A list of brokers that a client application can use to bootstrap.
 */
public suspend inline fun KafkaClient.getBootstrapBrokers(crossinline block: GetBootstrapBrokersRequest.Builder.() -> Unit): GetBootstrapBrokersResponse = getBootstrapBrokers(GetBootstrapBrokersRequest.Builder().apply(block).build())

/**
 * Gets the Apache Kafka versions to which you can update the MSK cluster.
 */
public suspend inline fun KafkaClient.getCompatibleKafkaVersions(crossinline block: GetCompatibleKafkaVersionsRequest.Builder.() -> Unit): GetCompatibleKafkaVersionsResponse = getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the operations that have been performed on the specified MSK cluster.
 */
public suspend inline fun KafkaClient.listClusterOperations(crossinline block: ListClusterOperationsRequest.Builder.() -> Unit): ListClusterOperationsResponse = listClusterOperations(ListClusterOperationsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClustersV2(crossinline block: ListClustersV2Request.Builder.() -> Unit): ListClustersV2Response = listClustersV2(ListClustersV2Request.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurationRevisions(crossinline block: ListConfigurationRevisionsRequest.Builder.() -> Unit): ListConfigurationRevisionsResponse = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of Apache Kafka versions.
 */
public suspend inline fun KafkaClient.listKafkaVersions(crossinline block: ListKafkaVersionsRequest.Builder.() -> Unit): ListKafkaVersionsResponse = listKafkaVersions(ListKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.listScramSecrets(crossinline block: ListScramSecretsRequest.Builder.() -> Unit): ListScramSecretsResponse = listScramSecrets(ListScramSecretsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags associated with the specified resource.
 */
public suspend inline fun KafkaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Reboots brokers.
 */
public suspend inline fun KafkaClient.rebootBroker(crossinline block: RebootBrokerRequest.Builder.() -> Unit): RebootBrokerResponse = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified MSK resource.
 */
public suspend inline fun KafkaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the tags associated with the keys that are provided in the query.
 */
public suspend inline fun KafkaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the number of broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.updateBrokerCount(crossinline block: UpdateBrokerCountRequest.Builder.() -> Unit): UpdateBrokerCountResponse = updateBrokerCount(UpdateBrokerCountRequest.Builder().apply(block).build())

/**
 * Updates the EBS storage associated with MSK brokers.
 */
public suspend inline fun KafkaClient.updateBrokerStorage(crossinline block: UpdateBrokerStorageRequest.Builder.() -> Unit): UpdateBrokerStorageResponse = updateBrokerStorage(UpdateBrokerStorageRequest.Builder().apply(block).build())

/**
 * Updates EC2 instance type.
 */
public suspend inline fun KafkaClient.updateBrokerType(crossinline block: UpdateBrokerTypeRequest.Builder.() -> Unit): UpdateBrokerTypeResponse = updateBrokerType(UpdateBrokerTypeRequest.Builder().apply(block).build())

/**
 * Updates the cluster with the configuration that is specified in the request body.
 */
public suspend inline fun KafkaClient.updateClusterConfiguration(crossinline block: UpdateClusterConfigurationRequest.Builder.() -> Unit): UpdateClusterConfigurationResponse = updateClusterConfiguration(UpdateClusterConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the Apache Kafka version for the cluster.
 */
public suspend inline fun KafkaClient.updateClusterKafkaVersion(crossinline block: UpdateClusterKafkaVersionRequest.Builder.() -> Unit): UpdateClusterKafkaVersionResponse = updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.Builder().apply(block).build())

/**
 * Updates an MSK configuration.
 */
public suspend inline fun KafkaClient.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the cluster's connectivity configuration.
 */
public suspend inline fun KafkaClient.updateConnectivity(crossinline block: UpdateConnectivityRequest.Builder.() -> Unit): UpdateConnectivityResponse = updateConnectivity(UpdateConnectivityRequest.Builder().apply(block).build())

/**
 * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
 */
public suspend inline fun KafkaClient.updateMonitoring(crossinline block: UpdateMonitoringRequest.Builder.() -> Unit): UpdateMonitoringResponse = updateMonitoring(UpdateMonitoringRequest.Builder().apply(block).build())

/**
 * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
 */
public suspend inline fun KafkaClient.updateSecurity(crossinline block: UpdateSecurityRequest.Builder.() -> Unit): UpdateSecurityResponse = updateSecurity(UpdateSecurityRequest.Builder().apply(block).build())

/**
 * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
 */
public suspend inline fun KafkaClient.updateStorage(crossinline block: UpdateStorageRequest.Builder.() -> Unit): UpdateStorageResponse = updateStorage(UpdateStorageRequest.Builder().apply(block).build())
