// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
 */
public class UpdateStorageRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cluster to be updated.
     */
    public val clusterArn: kotlin.String? = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The version of cluster to update from. A successful operation will then generate a new version.
     */
    public val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * EBS volume provisioned throughput information.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.kafka.model.ProvisionedThroughput? = builder.provisionedThroughput
    /**
     * Controls storage mode for supported storage tiers.
     */
    public val storageMode: aws.sdk.kotlin.services.kafka.model.StorageMode? = builder.storageMode
    /**
     * size of the EBS volume to update.
     */
    public val volumeSizeGb: kotlin.Int = builder.volumeSizeGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStorageRequest(")
        append("clusterArn=$clusterArn,")
        append("currentVersion=$currentVersion,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("storageMode=$storageMode,")
        append("volumeSizeGb=$volumeSizeGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (storageMode?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeGb)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStorageRequest

        if (clusterArn != other.clusterArn) return false
        if (currentVersion != other.currentVersion) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (storageMode != other.storageMode) return false
        if (volumeSizeGb != other.volumeSizeGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cluster to be updated.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The version of cluster to update from. A successful operation will then generate a new version.
         */
        public var currentVersion: kotlin.String? = null
        /**
         * EBS volume provisioned throughput information.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.kafka.model.ProvisionedThroughput? = null
        /**
         * Controls storage mode for supported storage tiers.
         */
        public var storageMode: aws.sdk.kotlin.services.kafka.model.StorageMode? = null
        /**
         * size of the EBS volume to update.
         */
        public var volumeSizeGb: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest) : this() {
            this.clusterArn = x.clusterArn
            this.currentVersion = x.currentVersion
            this.provisionedThroughput = x.provisionedThroughput
            this.storageMode = x.storageMode
            this.volumeSizeGb = x.volumeSizeGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest = UpdateStorageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.kafka.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.kafka.model.ProvisionedThroughput.invoke(block)
        }
    }
}
