// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeConfigurationRevisionResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the configuration was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The revision number.
     */
    public val revision: kotlin.Long? = builder.revision
    /**
     * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
     */
    public val serverProperties: kotlin.ByteArray? = builder.serverProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConfigurationRevisionResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("revision=$revision,")
        append("serverProperties=$serverProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeConfigurationRevisionResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (revision != other.revision) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the configuration was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The revision number.
         */
        public var revision: kotlin.Long? = null
        /**
         * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
         */
        public var serverProperties: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.revision = x.revision
            this.serverProperties = x.serverProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse = DescribeConfigurationRevisionResponse(this)
    }
}
