// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.kafka.model.*
import aws.sdk.kotlin.services.kafka.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Kafka"
public const val ServiceApiVersion: String = "2018-11-14"
public const val SdkVersion: String = "0.17.5-beta"

internal class DefaultKafkaClient(override val config: KafkaClient.Config) : KafkaClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    override suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse {
        val op = SdkHttpOperation.build<BatchAssociateScramSecretRequest, BatchAssociateScramSecretResponse> {
            serializer = BatchAssociateScramSecretOperationSerializer()
            deserializer = BatchAssociateScramSecretOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateScramSecret"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    override suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse {
        val op = SdkHttpOperation.build<BatchDisassociateScramSecretRequest, BatchDisassociateScramSecretResponse> {
            serializer = BatchDisassociateScramSecretOperationSerializer()
            deserializer = BatchDisassociateScramSecretOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateScramSecret"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new MSK cluster.
     */
    override suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse {
        val op = SdkHttpOperation.build<CreateClusterRequest, CreateClusterResponse> {
            serializer = CreateClusterOperationSerializer()
            deserializer = CreateClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new MSK cluster.
     */
    override suspend fun createClusterV2(input: CreateClusterV2Request): CreateClusterV2Response {
        val op = SdkHttpOperation.build<CreateClusterV2Request, CreateClusterV2Response> {
            serializer = CreateClusterV2OperationSerializer()
            deserializer = CreateClusterV2OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClusterV2"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new MSK configuration.
     */
    override suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse {
        val op = SdkHttpOperation.build<CreateConfigurationRequest, CreateConfigurationResponse> {
            serializer = CreateConfigurationOperationSerializer()
            deserializer = CreateConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    override suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse {
        val op = SdkHttpOperation.build<DeleteClusterRequest, DeleteClusterResponse> {
            serializer = DeleteClusterOperationSerializer()
            deserializer = DeleteClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an MSK Configuration.
     */
    override suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationRequest, DeleteConfigurationResponse> {
            serializer = DeleteConfigurationOperationSerializer()
            deserializer = DeleteConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    override suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse {
        val op = SdkHttpOperation.build<DescribeClusterRequest, DescribeClusterResponse> {
            serializer = DescribeClusterOperationSerializer()
            deserializer = DescribeClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCluster"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    override suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse {
        val op = SdkHttpOperation.build<DescribeClusterOperationRequest, DescribeClusterOperationResponse> {
            serializer = DescribeClusterOperationOperationSerializer()
            deserializer = DescribeClusterOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterOperation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    override suspend fun describeClusterV2(input: DescribeClusterV2Request): DescribeClusterV2Response {
        val op = SdkHttpOperation.build<DescribeClusterV2Request, DescribeClusterV2Response> {
            serializer = DescribeClusterV2OperationSerializer()
            deserializer = DescribeClusterV2OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClusterV2"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of this MSK configuration.
     */
    override suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationRequest, DescribeConfigurationResponse> {
            serializer = DescribeConfigurationOperationSerializer()
            deserializer = DescribeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of this revision of the configuration.
     */
    override suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationRevisionRequest, DescribeConfigurationRevisionResponse> {
            serializer = DescribeConfigurationRevisionOperationSerializer()
            deserializer = DescribeConfigurationRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfigurationRevision"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    override suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse {
        val op = SdkHttpOperation.build<GetBootstrapBrokersRequest, GetBootstrapBrokersResponse> {
            serializer = GetBootstrapBrokersOperationSerializer()
            deserializer = GetBootstrapBrokersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBootstrapBrokers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    override suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest): GetCompatibleKafkaVersionsResponse {
        val op = SdkHttpOperation.build<GetCompatibleKafkaVersionsRequest, GetCompatibleKafkaVersionsResponse> {
            serializer = GetCompatibleKafkaVersionsOperationSerializer()
            deserializer = GetCompatibleKafkaVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCompatibleKafkaVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    override suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse {
        val op = SdkHttpOperation.build<ListClusterOperationsRequest, ListClusterOperationsResponse> {
            serializer = ListClusterOperationsOperationSerializer()
            deserializer = ListClusterOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClusterOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    override suspend fun listClusters(input: ListClustersRequest): ListClustersResponse {
        val op = SdkHttpOperation.build<ListClustersRequest, ListClustersResponse> {
            serializer = ListClustersOperationSerializer()
            deserializer = ListClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClusters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    override suspend fun listClustersV2(input: ListClustersV2Request): ListClustersV2Response {
        val op = SdkHttpOperation.build<ListClustersV2Request, ListClustersV2Response> {
            serializer = ListClustersV2OperationSerializer()
            deserializer = ListClustersV2OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClustersV2"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    override suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse {
        val op = SdkHttpOperation.build<ListConfigurationRevisionsRequest, ListConfigurationRevisionsResponse> {
            serializer = ListConfigurationRevisionsOperationSerializer()
            deserializer = ListConfigurationRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurationRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    override suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse {
        val op = SdkHttpOperation.build<ListConfigurationsRequest, ListConfigurationsResponse> {
            serializer = ListConfigurationsOperationSerializer()
            deserializer = ListConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Apache Kafka versions.
     */
    override suspend fun listKafkaVersions(input: ListKafkaVersionsRequest): ListKafkaVersionsResponse {
        val op = SdkHttpOperation.build<ListKafkaVersionsRequest, ListKafkaVersionsResponse> {
            serializer = ListKafkaVersionsOperationSerializer()
            deserializer = ListKafkaVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKafkaVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    override suspend fun listNodes(input: ListNodesRequest): ListNodesResponse {
        val op = SdkHttpOperation.build<ListNodesRequest, ListNodesResponse> {
            serializer = ListNodesOperationSerializer()
            deserializer = ListNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    override suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse {
        val op = SdkHttpOperation.build<ListScramSecretsRequest, ListScramSecretsResponse> {
            serializer = ListScramSecretsOperationSerializer()
            deserializer = ListScramSecretsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListScramSecrets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Reboots brokers.
     */
    override suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse {
        val op = SdkHttpOperation.build<RebootBrokerRequest, RebootBrokerResponse> {
            serializer = RebootBrokerOperationSerializer()
            deserializer = RebootBrokerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootBroker"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds tags to the specified MSK resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the number of broker nodes in the cluster.
     */
    override suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse {
        val op = SdkHttpOperation.build<UpdateBrokerCountRequest, UpdateBrokerCountResponse> {
            serializer = UpdateBrokerCountOperationSerializer()
            deserializer = UpdateBrokerCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBrokerCount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    override suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse {
        val op = SdkHttpOperation.build<UpdateBrokerStorageRequest, UpdateBrokerStorageResponse> {
            serializer = UpdateBrokerStorageOperationSerializer()
            deserializer = UpdateBrokerStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBrokerStorage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates EC2 instance type.
     */
    override suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse {
        val op = SdkHttpOperation.build<UpdateBrokerTypeRequest, UpdateBrokerTypeResponse> {
            serializer = UpdateBrokerTypeOperationSerializer()
            deserializer = UpdateBrokerTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBrokerType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    override suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateClusterConfigurationRequest, UpdateClusterConfigurationResponse> {
            serializer = UpdateClusterConfigurationOperationSerializer()
            deserializer = UpdateClusterConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateClusterConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    override suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse {
        val op = SdkHttpOperation.build<UpdateClusterKafkaVersionRequest, UpdateClusterKafkaVersionResponse> {
            serializer = UpdateClusterKafkaVersionOperationSerializer()
            deserializer = UpdateClusterKafkaVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateClusterKafkaVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an MSK configuration.
     */
    override suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationRequest, UpdateConfigurationResponse> {
            serializer = UpdateConfigurationOperationSerializer()
            deserializer = UpdateConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the cluster's connectivity configuration.
     */
    override suspend fun updateConnectivity(input: UpdateConnectivityRequest): UpdateConnectivityResponse {
        val op = SdkHttpOperation.build<UpdateConnectivityRequest, UpdateConnectivityResponse> {
            serializer = UpdateConnectivityOperationSerializer()
            deserializer = UpdateConnectivityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConnectivity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    override suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse {
        val op = SdkHttpOperation.build<UpdateMonitoringRequest, UpdateMonitoringResponse> {
            serializer = UpdateMonitoringOperationSerializer()
            deserializer = UpdateMonitoringOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMonitoring"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    override suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse {
        val op = SdkHttpOperation.build<UpdateSecurityRequest, UpdateSecurityResponse> {
            serializer = UpdateSecurityOperationSerializer()
            deserializer = UpdateSecurityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSecurity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kafka"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "kafka")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
