// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster operation.
 */
public class ClusterOperationInfo private constructor(builder: Builder) {
    /**
     * The ID of the API request that triggered this operation.
     */
    public val clientRequestId: kotlin.String? = builder.clientRequestId
    /**
     * ARN of the cluster.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The time that the operation was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time at which the operation finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Describes the error if the operation fails.
     */
    public val errorInfo: aws.sdk.kotlin.services.kafka.model.ErrorInfo? = builder.errorInfo
    /**
     * ARN of the cluster operation.
     */
    public val operationArn: kotlin.String? = builder.operationArn
    /**
     * State of the cluster operation.
     */
    public val operationState: kotlin.String? = builder.operationState
    /**
     * Steps completed during the operation.
     */
    public val operationSteps: List<ClusterOperationStep>? = builder.operationSteps
    /**
     * Type of the cluster operation.
     */
    public val operationType: kotlin.String? = builder.operationType
    /**
     * Information about cluster attributes before a cluster is updated.
     */
    public val sourceClusterInfo: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo? = builder.sourceClusterInfo
    /**
     * Information about cluster attributes after a cluster is updated.
     */
    public val targetClusterInfo: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo? = builder.targetClusterInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterOperationInfo(")
        append("clientRequestId=$clientRequestId,")
        append("clusterArn=$clusterArn,")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("errorInfo=$errorInfo,")
        append("operationArn=$operationArn,")
        append("operationState=$operationState,")
        append("operationSteps=$operationSteps,")
        append("operationType=$operationType,")
        append("sourceClusterInfo=$sourceClusterInfo,")
        append("targetClusterInfo=$targetClusterInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestId?.hashCode() ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (operationArn?.hashCode() ?: 0)
        result = 31 * result + (operationState?.hashCode() ?: 0)
        result = 31 * result + (operationSteps?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (sourceClusterInfo?.hashCode() ?: 0)
        result = 31 * result + (targetClusterInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterOperationInfo

        if (clientRequestId != other.clientRequestId) return false
        if (clusterArn != other.clusterArn) return false
        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (errorInfo != other.errorInfo) return false
        if (operationArn != other.operationArn) return false
        if (operationState != other.operationState) return false
        if (operationSteps != other.operationSteps) return false
        if (operationType != other.operationType) return false
        if (sourceClusterInfo != other.sourceClusterInfo) return false
        if (targetClusterInfo != other.targetClusterInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the API request that triggered this operation.
         */
        public var clientRequestId: kotlin.String? = null
        /**
         * ARN of the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The time that the operation was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the operation finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the error if the operation fails.
         */
        public var errorInfo: aws.sdk.kotlin.services.kafka.model.ErrorInfo? = null
        /**
         * ARN of the cluster operation.
         */
        public var operationArn: kotlin.String? = null
        /**
         * State of the cluster operation.
         */
        public var operationState: kotlin.String? = null
        /**
         * Steps completed during the operation.
         */
        public var operationSteps: List<ClusterOperationStep>? = null
        /**
         * Type of the cluster operation.
         */
        public var operationType: kotlin.String? = null
        /**
         * Information about cluster attributes before a cluster is updated.
         */
        public var sourceClusterInfo: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo? = null
        /**
         * Information about cluster attributes after a cluster is updated.
         */
        public var targetClusterInfo: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo) : this() {
            this.clientRequestId = x.clientRequestId
            this.clusterArn = x.clusterArn
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.errorInfo = x.errorInfo
            this.operationArn = x.operationArn
            this.operationState = x.operationState
            this.operationSteps = x.operationSteps
            this.operationType = x.operationType
            this.sourceClusterInfo = x.sourceClusterInfo
            this.targetClusterInfo = x.targetClusterInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo = ClusterOperationInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.kafka.model.ErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.kafka.model.ErrorInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.MutableClusterInfo] inside the given [block]
         */
        public fun sourceClusterInfo(block: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo.Builder.() -> kotlin.Unit) {
            this.sourceClusterInfo = aws.sdk.kotlin.services.kafka.model.MutableClusterInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.MutableClusterInfo] inside the given [block]
         */
        public fun targetClusterInfo(block: aws.sdk.kotlin.services.kafka.model.MutableClusterInfo.Builder.() -> kotlin.Unit) {
            this.targetClusterInfo = aws.sdk.kotlin.services.kafka.model.MutableClusterInfo.invoke(block)
        }
    }
}
