// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafka.model.ClusterState
import aws.sdk.kotlin.services.kafka.model.CreateClusterResponse
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClusterOperationDeserializer: HttpDeserialize<CreateClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateClusterResponse {
        if (!response.status.isSuccess()) {
            throwCreateClusterError(context, response)
        }
        val builder = CreateClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateClusterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterOperationBody(builder: CreateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterArn"))
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterName"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERARN_DESCRIPTOR)
        field(CLUSTERNAME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                CLUSTERNAME_DESCRIPTOR.index -> builder.clusterName = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ClusterState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
