// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.transform

import aws.sdk.kotlin.services.kafka.model.RebootBrokerRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RebootBrokerOperationSerializer: HttpSerialize<RebootBrokerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RebootBrokerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "clusters",
                "${input.clusterArn}".encodeLabel(),
                "reboot-broker",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeRebootBrokerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRebootBrokerOperationBody(context: ExecutionContext, input: RebootBrokerRequest): ByteArray {
    val serializer = JsonSerializer()
    val BROKERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("brokerIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BROKERIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.brokerIds != null) {
            listField(BROKERIDS_DESCRIPTOR) {
                for (el0 in input.brokerIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
