// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster.
 */
public class ClusterInfo private constructor(builder: Builder) {
    /**
     * Arn of active cluster operation.
     */
    public val activeOperationArn: kotlin.String? = builder.activeOperationArn
    /**
     * Information about the broker nodes.
     */
    public val brokerNodeGroupInfo: aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo? = builder.brokerNodeGroupInfo
    /**
     * Includes all client authentication information.
     */
    public val clientAuthentication: aws.sdk.kotlin.services.kafka.model.ClientAuthentication? = builder.clientAuthentication
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The name of the cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The time when the cluster was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
     */
    public val currentBrokerSoftwareInfo: aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo? = builder.currentBrokerSoftwareInfo
    /**
     * The current version of the MSK cluster.
     */
    public val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Includes all encryption-related information.
     */
    public val encryptionInfo: aws.sdk.kotlin.services.kafka.model.EncryptionInfo? = builder.encryptionInfo
    /**
     * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see [Monitoring](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
     */
    public val enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = builder.enhancedMonitoring
    public val loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = builder.loggingInfo
    /**
     * The number of broker nodes in the cluster.
     */
    public val numberOfBrokerNodes: kotlin.Int = builder.numberOfBrokerNodes
    /**
     * Settings for open monitoring using Prometheus.
     */
    public val openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoring? = builder.openMonitoring
    /**
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     */
    public val state: aws.sdk.kotlin.services.kafka.model.ClusterState? = builder.state
    public val stateInfo: aws.sdk.kotlin.services.kafka.model.StateInfo? = builder.stateInfo
    /**
     * Tags attached to the cluster.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The connection string to use to connect to the Apache ZooKeeper cluster.
     */
    public val zookeeperConnectString: kotlin.String? = builder.zookeeperConnectString
    /**
     * The connection string to use to connect to zookeeper cluster on Tls port.
     */
    public val zookeeperConnectStringTls: kotlin.String? = builder.zookeeperConnectStringTls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.ClusterInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterInfo(")
        append("activeOperationArn=$activeOperationArn,")
        append("brokerNodeGroupInfo=$brokerNodeGroupInfo,")
        append("clientAuthentication=$clientAuthentication,")
        append("clusterArn=$clusterArn,")
        append("clusterName=$clusterName,")
        append("creationTime=$creationTime,")
        append("currentBrokerSoftwareInfo=$currentBrokerSoftwareInfo,")
        append("currentVersion=$currentVersion,")
        append("encryptionInfo=$encryptionInfo,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("loggingInfo=$loggingInfo,")
        append("numberOfBrokerNodes=$numberOfBrokerNodes,")
        append("openMonitoring=$openMonitoring,")
        append("state=$state,")
        append("stateInfo=$stateInfo,")
        append("tags=$tags,")
        append("zookeeperConnectString=$zookeeperConnectString,")
        append("zookeeperConnectStringTls=$zookeeperConnectStringTls)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeOperationArn?.hashCode() ?: 0
        result = 31 * result + (brokerNodeGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (clientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentBrokerSoftwareInfo?.hashCode() ?: 0)
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionInfo?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (numberOfBrokerNodes)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateInfo?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (zookeeperConnectString?.hashCode() ?: 0)
        result = 31 * result + (zookeeperConnectStringTls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterInfo

        if (activeOperationArn != other.activeOperationArn) return false
        if (brokerNodeGroupInfo != other.brokerNodeGroupInfo) return false
        if (clientAuthentication != other.clientAuthentication) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterName != other.clusterName) return false
        if (creationTime != other.creationTime) return false
        if (currentBrokerSoftwareInfo != other.currentBrokerSoftwareInfo) return false
        if (currentVersion != other.currentVersion) return false
        if (encryptionInfo != other.encryptionInfo) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (loggingInfo != other.loggingInfo) return false
        if (numberOfBrokerNodes != other.numberOfBrokerNodes) return false
        if (openMonitoring != other.openMonitoring) return false
        if (state != other.state) return false
        if (stateInfo != other.stateInfo) return false
        if (tags != other.tags) return false
        if (zookeeperConnectString != other.zookeeperConnectString) return false
        if (zookeeperConnectStringTls != other.zookeeperConnectStringTls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.ClusterInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Arn of active cluster operation.
         */
        public var activeOperationArn: kotlin.String? = null
        /**
         * Information about the broker nodes.
         */
        public var brokerNodeGroupInfo: aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo? = null
        /**
         * Includes all client authentication information.
         */
        public var clientAuthentication: aws.sdk.kotlin.services.kafka.model.ClientAuthentication? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The time when the cluster was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
         */
        public var currentBrokerSoftwareInfo: aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo? = null
        /**
         * The current version of the MSK cluster.
         */
        public var currentVersion: kotlin.String? = null
        /**
         * Includes all encryption-related information.
         */
        public var encryptionInfo: aws.sdk.kotlin.services.kafka.model.EncryptionInfo? = null
        /**
         * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see [Monitoring](https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
         */
        public var enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = null
        public var loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = null
        /**
         * The number of broker nodes in the cluster.
         */
        public var numberOfBrokerNodes: kotlin.Int = 0
        /**
         * Settings for open monitoring using Prometheus.
         */
        public var openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoring? = null
        /**
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         */
        public var state: aws.sdk.kotlin.services.kafka.model.ClusterState? = null
        public var stateInfo: aws.sdk.kotlin.services.kafka.model.StateInfo? = null
        /**
         * Tags attached to the cluster.
         */
        public var tags: Map<String, String>? = null
        /**
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         */
        public var zookeeperConnectString: kotlin.String? = null
        /**
         * The connection string to use to connect to zookeeper cluster on Tls port.
         */
        public var zookeeperConnectStringTls: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.ClusterInfo) : this() {
            this.activeOperationArn = x.activeOperationArn
            this.brokerNodeGroupInfo = x.brokerNodeGroupInfo
            this.clientAuthentication = x.clientAuthentication
            this.clusterArn = x.clusterArn
            this.clusterName = x.clusterName
            this.creationTime = x.creationTime
            this.currentBrokerSoftwareInfo = x.currentBrokerSoftwareInfo
            this.currentVersion = x.currentVersion
            this.encryptionInfo = x.encryptionInfo
            this.enhancedMonitoring = x.enhancedMonitoring
            this.loggingInfo = x.loggingInfo
            this.numberOfBrokerNodes = x.numberOfBrokerNodes
            this.openMonitoring = x.openMonitoring
            this.state = x.state
            this.stateInfo = x.stateInfo
            this.tags = x.tags
            this.zookeeperConnectString = x.zookeeperConnectString
            this.zookeeperConnectStringTls = x.zookeeperConnectStringTls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.ClusterInfo = ClusterInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo] inside the given [block]
         */
        public fun brokerNodeGroupInfo(block: aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo.Builder.() -> kotlin.Unit) {
            this.brokerNodeGroupInfo = aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClientAuthentication] inside the given [block]
         */
        public fun clientAuthentication(block: aws.sdk.kotlin.services.kafka.model.ClientAuthentication.Builder.() -> kotlin.Unit) {
            this.clientAuthentication = aws.sdk.kotlin.services.kafka.model.ClientAuthentication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo] inside the given [block]
         */
        public fun currentBrokerSoftwareInfo(block: aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo.Builder.() -> kotlin.Unit) {
            this.currentBrokerSoftwareInfo = aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.EncryptionInfo] inside the given [block]
         */
        public fun encryptionInfo(block: aws.sdk.kotlin.services.kafka.model.EncryptionInfo.Builder.() -> kotlin.Unit) {
            this.encryptionInfo = aws.sdk.kotlin.services.kafka.model.EncryptionInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        public fun loggingInfo(block: aws.sdk.kotlin.services.kafka.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.kafka.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoring] inside the given [block]
         */
        public fun openMonitoring(block: aws.sdk.kotlin.services.kafka.model.OpenMonitoring.Builder.() -> kotlin.Unit) {
            this.openMonitoring = aws.sdk.kotlin.services.kafka.model.OpenMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StateInfo] inside the given [block]
         */
        public fun stateInfo(block: aws.sdk.kotlin.services.kafka.model.StateInfo.Builder.() -> kotlin.Unit) {
            this.stateInfo = aws.sdk.kotlin.services.kafka.model.StateInfo.invoke(block)
        }
    }
}
