// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.kendra.model.*
import aws.sdk.kotlin.services.kendra.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "kendra"
const val ServiceApiVersion: String = "2019-02-03"
const val SdkVersion: String = "0.16.5-beta"

internal class DefaultKendraClient(override val config: KendraClient.Config) : KendraClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Grants users or groups in your Amazon Web Services SSO identity source access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun associateEntitiesToExperience(input: AssociateEntitiesToExperienceRequest): AssociateEntitiesToExperienceResponse {
        val op = SdkHttpOperation.build<AssociateEntitiesToExperienceRequest, AssociateEntitiesToExperienceResponse> {
            serializer = AssociateEntitiesToExperienceOperationSerializer()
            deserializer = AssociateEntitiesToExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateEntitiesToExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Defines the specific permissions of users or groups in your Amazon Web Services SSO identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun associatePersonasToEntities(input: AssociatePersonasToEntitiesRequest): AssociatePersonasToEntitiesResponse {
        val op = SdkHttpOperation.build<AssociatePersonasToEntitiesRequest, AssociatePersonasToEntitiesResponse> {
            serializer = AssociatePersonasToEntitiesOperationSerializer()
            deserializer = AssociatePersonasToEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociatePersonasToEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more documents from an index. The documents must have been added with the `BatchPutDocument` API.
     *
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     */
    override suspend fun batchDeleteDocument(input: BatchDeleteDocumentRequest): BatchDeleteDocumentResponse {
        val op = SdkHttpOperation.build<BatchDeleteDocumentRequest, BatchDeleteDocumentResponse> {
            serializer = BatchDeleteDocumentOperationSerializer()
            deserializer = BatchDeleteDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the indexing status for one or more documents submitted with the [ BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API.
     *
     * When you use the `BatchPutDocument` API, documents are indexed asynchronously. You can use the `BatchGetDocumentStatus` API to get the current status of a list of documents so that you can determine if they have been successfully indexed.
     *
     * You can also use the `BatchGetDocumentStatus` API to check the status of the [ BatchDeleteDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html) API. When a document is deleted from the index, Amazon Kendra returns `NOT_FOUND` as the status.
     */
    override suspend fun batchGetDocumentStatus(input: BatchGetDocumentStatusRequest): BatchGetDocumentStatusResponse {
        val op = SdkHttpOperation.build<BatchGetDocumentStatusRequest, BatchGetDocumentStatusResponse> {
            serializer = BatchGetDocumentStatusOperationSerializer()
            deserializer = BatchGetDocumentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetDocumentStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more documents to an index.
     *
     * The `BatchPutDocument` API enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index.
     *
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log.
     */
    override suspend fun batchPutDocument(input: BatchPutDocumentRequest): BatchPutDocumentResponse {
        val op = SdkHttpOperation.build<BatchPutDocumentRequest, BatchPutDocumentResponse> {
            serializer = BatchPutDocumentOperationSerializer()
            deserializer = BatchPutDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Clears existing query suggestions from an index.
     *
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.
     *
     * `ClearQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun clearQuerySuggestions(input: ClearQuerySuggestionsRequest): ClearQuerySuggestionsResponse {
        val op = SdkHttpOperation.build<ClearQuerySuggestionsRequest, ClearQuerySuggestionsResponse> {
            serializer = ClearQuerySuggestionsOperationSerializer()
            deserializer = ClearQuerySuggestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClearQuerySuggestions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a data source that you want to use with an Amazon Kendra index.
     *
     * You specify a name, data source connector type and description for your data source. You also specify configuration information for the data source connector.
     *
     * `CreateDataSource` is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
     *
     * Amazon S3 and [custom](https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html) data sources are the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse {
        val op = SdkHttpOperation.build<CreateDataSourceRequest, CreateDataSourceResponse> {
            serializer = CreateDataSourceOperationSerializer()
            deserializer = CreateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun createExperience(input: CreateExperienceRequest): CreateExperienceResponse {
        val op = SdkHttpOperation.build<CreateExperienceRequest, CreateExperienceResponse> {
            serializer = CreateExperienceOperationSerializer()
            deserializer = CreateExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     *
     * Adding FAQs to an index is an asynchronous operation.
     */
    override suspend fun createFaq(input: CreateFaqRequest): CreateFaqResponse {
        val op = SdkHttpOperation.build<CreateFaqRequest, CreateFaqResponse> {
            serializer = CreateFaqOperationSerializer()
            deserializer = CreateFaqOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFaq"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has completed, check the `Status` field returned from a call to `DescribeIndex`. The `Status` field is set to `ACTIVE` when the index is ready to use.
     *
     * Once the index is active you can index your documents using the `BatchPutDocument` API or using one of the supported data sources.
     */
    override suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse {
        val op = SdkHttpOperation.build<CreateIndexRequest, CreateIndexResponse> {
            serializer = CreateIndexOperationSerializer()
            deserializer = CreateIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a block list to exlcude certain queries from suggestions.
     *
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion.
     *
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     *
     * `CreateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun createQuerySuggestionsBlockList(input: CreateQuerySuggestionsBlockListRequest): CreateQuerySuggestionsBlockListResponse {
        val op = SdkHttpOperation.build<CreateQuerySuggestionsBlockListRequest, CreateQuerySuggestionsBlockListResponse> {
            serializer = CreateQuerySuggestionsBlockListOperationSerializer()
            deserializer = CreateQuerySuggestionsBlockListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateQuerySuggestionsBlockList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     */
    override suspend fun createThesaurus(input: CreateThesaurusRequest): CreateThesaurusResponse {
        val op = SdkHttpOperation.build<CreateThesaurusRequest, CreateThesaurusResponse> {
            serializer = CreateThesaurusOperationSerializer()
            deserializer = CreateThesaurusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateThesaurus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Kendra data source. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the `Status` field returned by a call to the `DescribeDataSource` API is set to `DELETING`. For more information, see [Deleting Data Sources](https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html).
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun deleteExperience(input: DeleteExperienceRequest): DeleteExperienceResponse {
        val op = SdkHttpOperation.build<DeleteExperienceRequest, DeleteExperienceResponse> {
            serializer = DeleteExperienceOperationSerializer()
            deserializer = DeleteExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an FAQ from an index.
     */
    override suspend fun deleteFaq(input: DeleteFaqRequest): DeleteFaqResponse {
        val op = SdkHttpOperation.build<DeleteFaqRequest, DeleteFaqResponse> {
            serializer = DeleteFaqOperationSerializer()
            deserializer = DeleteFaqOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFaq"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the `Status` field returned by a call to the `DescribeIndex` API is set to `DELETING`.
     */
    override suspend fun deleteIndex(input: DeleteIndexRequest): DeleteIndexResponse {
        val op = SdkHttpOperation.build<DeleteIndexRequest, DeleteIndexResponse> {
            serializer = DeleteIndexOperationSerializer()
            deserializer = DeleteIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.
     *
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results.
     *
     * If you want to delete or replace users or sub groups of a group, you need to use the `PutPrincipalMapping` operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling `PutPrincipalMapping`. You can update your internal list of users or sub groups and input this list when calling `PutPrincipalMapping`.
     *
     * `DeletePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun deletePrincipalMapping(input: DeletePrincipalMappingRequest): DeletePrincipalMappingResponse {
        val op = SdkHttpOperation.build<DeletePrincipalMappingRequest, DeletePrincipalMappingResponse> {
            serializer = DeletePrincipalMappingOperationSerializer()
            deserializer = DeletePrincipalMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePrincipalMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a block list used for query suggestions for an index.
     *
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.
     *
     * `DeleteQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun deleteQuerySuggestionsBlockList(input: DeleteQuerySuggestionsBlockListRequest): DeleteQuerySuggestionsBlockListResponse {
        val op = SdkHttpOperation.build<DeleteQuerySuggestionsBlockListRequest, DeleteQuerySuggestionsBlockListResponse> {
            serializer = DeleteQuerySuggestionsBlockListOperationSerializer()
            deserializer = DeleteQuerySuggestionsBlockListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteQuerySuggestionsBlockList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amazon Kendra thesaurus.
     */
    override suspend fun deleteThesaurus(input: DeleteThesaurusRequest): DeleteThesaurusResponse {
        val op = SdkHttpOperation.build<DeleteThesaurusRequest, DeleteThesaurusResponse> {
            serializer = DeleteThesaurusOperationSerializer()
            deserializer = DeleteThesaurusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteThesaurus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an Amazon Kendra data source.
     */
    override suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse {
        val op = SdkHttpOperation.build<DescribeDataSourceRequest, DescribeDataSourceResponse> {
            serializer = DescribeDataSourceOperationSerializer()
            deserializer = DescribeDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun describeExperience(input: DescribeExperienceRequest): DescribeExperienceResponse {
        val op = SdkHttpOperation.build<DescribeExperienceRequest, DescribeExperienceResponse> {
            serializer = DescribeExperienceOperationSerializer()
            deserializer = DescribeExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an FAQ list.
     */
    override suspend fun describeFaq(input: DescribeFaqRequest): DescribeFaqResponse {
        val op = SdkHttpOperation.build<DescribeFaqRequest, DescribeFaqResponse> {
            serializer = DescribeFaqOperationSerializer()
            deserializer = DescribeFaqOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFaq"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing Amazon Kendra index.
     */
    override suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse {
        val op = SdkHttpOperation.build<DescribeIndexRequest, DescribeIndexResponse> {
            serializer = DescribeIndexOperationSerializer()
            deserializer = DescribeIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the processing of `PUT` and `DELETE` actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.
     *
     * `DescribePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun describePrincipalMapping(input: DescribePrincipalMappingRequest): DescribePrincipalMappingResponse {
        val op = SdkHttpOperation.build<DescribePrincipalMappingRequest, DescribePrincipalMappingResponse> {
            serializer = DescribePrincipalMappingOperationSerializer()
            deserializer = DescribePrincipalMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePrincipalMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a block list used for query suggestions for an index.
     *
     * This is used to check the current settings that are applied to a block list.
     *
     * `DescribeQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun describeQuerySuggestionsBlockList(input: DescribeQuerySuggestionsBlockListRequest): DescribeQuerySuggestionsBlockListResponse {
        val op = SdkHttpOperation.build<DescribeQuerySuggestionsBlockListRequest, DescribeQuerySuggestionsBlockListResponse> {
            serializer = DescribeQuerySuggestionsBlockListOperationSerializer()
            deserializer = DescribeQuerySuggestionsBlockListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeQuerySuggestionsBlockList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings of query suggestions for an index.
     *
     * This is used to check the current settings applied to query suggestions.
     *
     * `DescribeQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun describeQuerySuggestionsConfig(input: DescribeQuerySuggestionsConfigRequest): DescribeQuerySuggestionsConfigResponse {
        val op = SdkHttpOperation.build<DescribeQuerySuggestionsConfigRequest, DescribeQuerySuggestionsConfigResponse> {
            serializer = DescribeQuerySuggestionsConfigOperationSerializer()
            deserializer = DescribeQuerySuggestionsConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeQuerySuggestionsConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing Amazon Kendra thesaurus.
     */
    override suspend fun describeThesaurus(input: DescribeThesaurusRequest): DescribeThesaurusResponse {
        val op = SdkHttpOperation.build<DescribeThesaurusRequest, DescribeThesaurusResponse> {
            serializer = DescribeThesaurusOperationSerializer()
            deserializer = DescribeThesaurusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThesaurus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Prevents users or groups in your Amazon Web Services SSO identity source from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun disassociateEntitiesFromExperience(input: DisassociateEntitiesFromExperienceRequest): DisassociateEntitiesFromExperienceResponse {
        val op = SdkHttpOperation.build<DisassociateEntitiesFromExperienceRequest, DisassociateEntitiesFromExperienceResponse> {
            serializer = DisassociateEntitiesFromExperienceOperationSerializer()
            deserializer = DisassociateEntitiesFromExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateEntitiesFromExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specific permissions of users or groups in your Amazon Web Services SSO identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun disassociatePersonasFromEntities(input: DisassociatePersonasFromEntitiesRequest): DisassociatePersonasFromEntitiesResponse {
        val op = SdkHttpOperation.build<DisassociatePersonasFromEntitiesRequest, DisassociatePersonasFromEntitiesResponse> {
            serializer = DisassociatePersonasFromEntitiesOperationSerializer()
            deserializer = DisassociatePersonasFromEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociatePersonasFromEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Fetches the queries that are suggested to your users.
     *
     * `GetQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun getQuerySuggestions(input: GetQuerySuggestionsRequest): GetQuerySuggestionsResponse {
        val op = SdkHttpOperation.build<GetQuerySuggestionsRequest, GetQuerySuggestionsResponse> {
            serializer = GetQuerySuggestionsOperationSerializer()
            deserializer = GetQuerySuggestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQuerySuggestions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.
     */
    override suspend fun getSnapshots(input: GetSnapshotsRequest): GetSnapshotsResponse {
        val op = SdkHttpOperation.build<GetSnapshotsRequest, GetSnapshotsResponse> {
            serializer = GetSnapshotsOperationSerializer()
            deserializer = GetSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets statistics about synchronizing Amazon Kendra with a data source.
     */
    override suspend fun listDataSourceSyncJobs(input: ListDataSourceSyncJobsRequest): ListDataSourceSyncJobsResponse {
        val op = SdkHttpOperation.build<ListDataSourceSyncJobsRequest, ListDataSourceSyncJobsResponse> {
            serializer = ListDataSourceSyncJobsOperationSerializer()
            deserializer = ListDataSourceSyncJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSourceSyncJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the data sources that you have created.
     */
    override suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse {
        val op = SdkHttpOperation.build<ListDataSourcesRequest, ListDataSourcesResponse> {
            serializer = ListDataSourcesOperationSerializer()
            deserializer = ListDataSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     */
    override suspend fun listEntityPersonas(input: ListEntityPersonasRequest): ListEntityPersonasResponse {
        val op = SdkHttpOperation.build<ListEntityPersonasRequest, ListEntityPersonasResponse> {
            serializer = ListEntityPersonasOperationSerializer()
            deserializer = ListEntityPersonasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntityPersonas"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists users or groups in your Amazon Web Services SSO identity source that are granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun listExperienceEntities(input: ListExperienceEntitiesRequest): ListExperienceEntitiesResponse {
        val op = SdkHttpOperation.build<ListExperienceEntitiesRequest, ListExperienceEntitiesResponse> {
            serializer = ListExperienceEntitiesOperationSerializer()
            deserializer = ListExperienceEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExperienceEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun listExperiences(input: ListExperiencesRequest): ListExperiencesResponse {
        val op = SdkHttpOperation.build<ListExperiencesRequest, ListExperiencesResponse> {
            serializer = ListExperiencesOperationSerializer()
            deserializer = ListExperiencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExperiences"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of FAQ lists associated with an index.
     */
    override suspend fun listFaqs(input: ListFaqsRequest): ListFaqsResponse {
        val op = SdkHttpOperation.build<ListFaqsRequest, ListFaqsResponse> {
            serializer = ListFaqsOperationSerializer()
            deserializer = ListFaqsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFaqs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     *
     * `ListGroupsOlderThanOrderingId` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun listGroupsOlderThanOrderingId(input: ListGroupsOlderThanOrderingIdRequest): ListGroupsOlderThanOrderingIdResponse {
        val op = SdkHttpOperation.build<ListGroupsOlderThanOrderingIdRequest, ListGroupsOlderThanOrderingIdResponse> {
            serializer = ListGroupsOlderThanOrderingIdOperationSerializer()
            deserializer = ListGroupsOlderThanOrderingIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroupsOlderThanOrderingId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Kendra indexes that you created.
     */
    override suspend fun listIndices(input: ListIndicesRequest): ListIndicesResponse {
        val op = SdkHttpOperation.build<ListIndicesRequest, ListIndicesResponse> {
            serializer = ListIndicesOperationSerializer()
            deserializer = ListIndicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIndices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the block lists used for query suggestions for an index.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     *
     * `ListQuerySuggestionsBlockLists` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun listQuerySuggestionsBlockLists(input: ListQuerySuggestionsBlockListsRequest): ListQuerySuggestionsBlockListsResponse {
        val op = SdkHttpOperation.build<ListQuerySuggestionsBlockListsRequest, ListQuerySuggestionsBlockListsResponse> {
            serializer = ListQuerySuggestionsBlockListsOperationSerializer()
            deserializer = ListQuerySuggestionsBlockListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListQuerySuggestionsBlockLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Kendra thesauri associated with an index.
     */
    override suspend fun listThesauri(input: ListThesauriRequest): ListThesauriResponse {
        val op = SdkHttpOperation.build<ListThesauriRequest, ListThesauriResponse> {
            serializer = ListThesauriOperationSerializer()
            deserializer = ListThesauriOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThesauri"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     *
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results.
     *
     * You map users to their groups when you want to filter search results for different users based on their group’s access to documents. For more information on filtering search results for different users, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
     *
     * If more than five `PUT` actions for a group are currently processing, a validation exception is thrown.
     *
     * `PutPrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun putPrincipalMapping(input: PutPrincipalMappingRequest): PutPrincipalMappingResponse {
        val op = SdkHttpOperation.build<PutPrincipalMappingRequest, PutPrincipalMappingResponse> {
            serializer = PutPrincipalMappingOperationSerializer()
            deserializer = PutPrincipalMappingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutPrincipalMapping"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches an active index. Use this API to search your documents using query. The `Query` API enables to do faceted search and to filter results based on document attributes.
     *
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the search results.
     *
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response contains three types of results.
     * + Relevant passages
     * + Matching FAQs
     * + Relevant documents
     *
     * You can specify that the query return only one type of result using the `QueryResultTypeConfig` parameter.
     *
     * Each query returns the 100 most relevant results.
     */
    override suspend fun query(input: QueryRequest): QueryResponse {
        val op = SdkHttpOperation.build<QueryRequest, QueryResponse> {
            serializer = QueryOperationSerializer()
            deserializer = QueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Query"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a synchronization job for a data source. If a synchronization job is already in progress, Amazon Kendra returns a `ResourceInUseException` exception.
     */
    override suspend fun startDataSourceSyncJob(input: StartDataSourceSyncJobRequest): StartDataSourceSyncJobResponse {
        val op = SdkHttpOperation.build<StartDataSourceSyncJobRequest, StartDataSourceSyncJobResponse> {
            serializer = StartDataSourceSyncJobOperationSerializer()
            deserializer = StartDataSourceSyncJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDataSourceSyncJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
     */
    override suspend fun stopDataSourceSyncJob(input: StopDataSourceSyncJobRequest): StopDataSourceSyncJobResponse {
        val op = SdkHttpOperation.build<StopDataSourceSyncJobRequest, StopDataSourceSyncJobResponse> {
            serializer = StopDataSourceSyncJobOperationSerializer()
            deserializer = StopDataSourceSyncJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopDataSourceSyncJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     *
     * `SubmitFeedback` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse {
        val op = SdkHttpOperation.build<SubmitFeedbackRequest, SubmitFeedbackResponse> {
            serializer = SubmitFeedbackOperationSerializer()
            deserializer = SubmitFeedbackOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SubmitFeedback"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from an index, FAQ, or a data source.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amazon Kendra data source.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    override suspend fun updateExperience(input: UpdateExperienceRequest): UpdateExperienceResponse {
        val op = SdkHttpOperation.build<UpdateExperienceRequest, UpdateExperienceResponse> {
            serializer = UpdateExperienceOperationSerializer()
            deserializer = UpdateExperienceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateExperience"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amazon Kendra index.
     */
    override suspend fun updateIndex(input: UpdateIndexRequest): UpdateIndexResponse {
        val op = SdkHttpOperation.build<UpdateIndexRequest, UpdateIndexResponse> {
            serializer = UpdateIndexOperationSerializer()
            deserializer = UpdateIndexOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIndex"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a block list used for query suggestions for an index.
     *
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     *
     * If a block list is updating, then you need to wait for the first update to finish before submitting another update.
     *
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     *
     * `UpdateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun updateQuerySuggestionsBlockList(input: UpdateQuerySuggestionsBlockListRequest): UpdateQuerySuggestionsBlockListResponse {
        val op = SdkHttpOperation.build<UpdateQuerySuggestionsBlockListRequest, UpdateQuerySuggestionsBlockListResponse> {
            serializer = UpdateQuerySuggestionsBlockListOperationSerializer()
            deserializer = UpdateQuerySuggestionsBlockListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateQuerySuggestionsBlockList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the settings of query suggestions for an index.
     *
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     *
     * If an update is currently processing (i.e. 'happening'), you need to wait for the update to finish before making another update.
     *
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index.
     *
     * You can still enable/disable query suggestions at any time.
     *
     * `UpdateQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    override suspend fun updateQuerySuggestionsConfig(input: UpdateQuerySuggestionsConfigRequest): UpdateQuerySuggestionsConfigResponse {
        val op = SdkHttpOperation.build<UpdateQuerySuggestionsConfigRequest, UpdateQuerySuggestionsConfigResponse> {
            serializer = UpdateQuerySuggestionsConfigOperationSerializer()
            deserializer = UpdateQuerySuggestionsConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateQuerySuggestionsConfig"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a thesaurus file associated with an index.
     */
    override suspend fun updateThesaurus(input: UpdateThesaurusRequest): UpdateThesaurusResponse {
        val op = SdkHttpOperation.build<UpdateThesaurusRequest, UpdateThesaurusResponse> {
            serializer = UpdateThesaurusOperationSerializer()
            deserializer = UpdateThesaurusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThesaurus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSKendraFrontendService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kendra"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "kendra")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
