// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides filtering the query results based on document attributes.
 *
 * When you use the `AndAllFilters` or `OrAllFilters`, filters you can use 2 layers under the first attribute filter. For example, you can use:
 *
 * `<AndAllFilters>`
 * + ` <OrAllFilters>`
 * + ` <EqualsTo>`
 *
 * If you use more than 2 layers, you receive a `ValidationException` exception with the message "`AttributeFilter` cannot have a depth of more than 2."
 *
 * If you use more than 10 attribute filters in a given list for `AndAllFilters` or `OrAllFilters`, you receive a `ValidationException` with the message "`AttributeFilter` cannot have a length of more than 10".
 */
class AttributeFilter private constructor(builder: Builder) {
    /**
     * Performs a logical `AND` operation on all supplied filters.
     */
    val andAllFilters: List<AttributeFilter>? = builder.andAllFilters
    /**
     * Returns true when a document contains all of the specified document attributes. This filter is only applicable to `StringListValue` metadata.
     */
    val containsAll: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.containsAll
    /**
     * Returns true when a document contains any of the specified document attributes. This filter is only applicable to `StringListValue` metadata.
     */
    val containsAny: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.containsAny
    /**
     * Performs an equals operation on two document attributes.
     */
    val equalsTo: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.equalsTo
    /**
     * Performs a greater than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
     */
    val greaterThan: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.greaterThan
    /**
     * Performs a greater or equals than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
     */
    val greaterThanOrEquals: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.greaterThanOrEquals
    /**
     * Performs a less than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
     */
    val lessThan: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.lessThan
    /**
     * Performs a less than or equals operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
     */
    val lessThanOrEquals: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = builder.lessThanOrEquals
    /**
     * Performs a logical `NOT` operation on all supplied filters.
     */
    val notFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = builder.notFilter
    /**
     * Performs a logical `OR` operation on all supplied filters.
     */
    val orAllFilters: List<AttributeFilter>? = builder.orAllFilters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.AttributeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeFilter(")
        append("andAllFilters=$andAllFilters,")
        append("containsAll=$containsAll,")
        append("containsAny=$containsAny,")
        append("equalsTo=$equalsTo,")
        append("greaterThan=$greaterThan,")
        append("greaterThanOrEquals=$greaterThanOrEquals,")
        append("lessThan=$lessThan,")
        append("lessThanOrEquals=$lessThanOrEquals,")
        append("notFilter=$notFilter,")
        append("orAllFilters=$orAllFilters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = andAllFilters?.hashCode() ?: 0
        result = 31 * result + (containsAll?.hashCode() ?: 0)
        result = 31 * result + (containsAny?.hashCode() ?: 0)
        result = 31 * result + (equalsTo?.hashCode() ?: 0)
        result = 31 * result + (greaterThan?.hashCode() ?: 0)
        result = 31 * result + (greaterThanOrEquals?.hashCode() ?: 0)
        result = 31 * result + (lessThan?.hashCode() ?: 0)
        result = 31 * result + (lessThanOrEquals?.hashCode() ?: 0)
        result = 31 * result + (notFilter?.hashCode() ?: 0)
        result = 31 * result + (orAllFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeFilter

        if (andAllFilters != other.andAllFilters) return false
        if (containsAll != other.containsAll) return false
        if (containsAny != other.containsAny) return false
        if (equalsTo != other.equalsTo) return false
        if (greaterThan != other.greaterThan) return false
        if (greaterThanOrEquals != other.greaterThanOrEquals) return false
        if (lessThan != other.lessThan) return false
        if (lessThanOrEquals != other.lessThanOrEquals) return false
        if (notFilter != other.notFilter) return false
        if (orAllFilters != other.orAllFilters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.AttributeFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * Performs a logical `AND` operation on all supplied filters.
         */
        var andAllFilters: List<AttributeFilter>? = null
        /**
         * Returns true when a document contains all of the specified document attributes. This filter is only applicable to `StringListValue` metadata.
         */
        var containsAll: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Returns true when a document contains any of the specified document attributes. This filter is only applicable to `StringListValue` metadata.
         */
        var containsAny: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs an equals operation on two document attributes.
         */
        var equalsTo: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs a greater than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
         */
        var greaterThan: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs a greater or equals than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
         */
        var greaterThanOrEquals: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs a less than operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
         */
        var lessThan: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs a less than or equals operation on two document attributes. Use with a document attribute of type `Date` or `Long`.
         */
        var lessThanOrEquals: aws.sdk.kotlin.services.kendra.model.DocumentAttribute? = null
        /**
         * Performs a logical `NOT` operation on all supplied filters.
         */
        var notFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = null
        /**
         * Performs a logical `OR` operation on all supplied filters.
         */
        var orAllFilters: List<AttributeFilter>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.AttributeFilter) : this() {
            this.andAllFilters = x.andAllFilters
            this.containsAll = x.containsAll
            this.containsAny = x.containsAny
            this.equalsTo = x.equalsTo
            this.greaterThan = x.greaterThan
            this.greaterThanOrEquals = x.greaterThanOrEquals
            this.lessThan = x.lessThan
            this.lessThanOrEquals = x.lessThanOrEquals
            this.notFilter = x.notFilter
            this.orAllFilters = x.orAllFilters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.AttributeFilter = AttributeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun containsAll(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.containsAll = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun containsAny(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.containsAny = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun equalsTo(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.equalsTo = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun greaterThan(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.greaterThan = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun greaterThanOrEquals(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.greaterThanOrEquals = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun lessThan(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.lessThan = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttribute] inside the given [block]
         */
        fun lessThanOrEquals(block: aws.sdk.kotlin.services.kendra.model.DocumentAttribute.Builder.() -> kotlin.Unit) {
            this.lessThanOrEquals = aws.sdk.kotlin.services.kendra.model.DocumentAttribute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeFilter] inside the given [block]
         */
        fun notFilter(block: aws.sdk.kotlin.services.kendra.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.notFilter = aws.sdk.kotlin.services.kendra.model.AttributeFilter.invoke(block)
        }
    }
}
