// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Specifies additional capacity units configured for your Enterprise Edition index. You can add and remove capacity units to fit your usage requirements.
 */
class CapacityUnitsConfiguration private constructor(builder: Builder) {
    /**
     * The amount of extra query capacity for an index and [GetQuerySuggestions](https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html) capacity.
     *
     * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day.
     *
     * `GetQuerySuggestions` capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and `GetQuerySuggestions` capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the `GetQuerySuggestions` capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
     */
    val queryCapacityUnits: kotlin.Int? = builder.queryCapacityUnits
    /**
     * The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first.
     */
    val storageCapacityUnits: kotlin.Int? = builder.storageCapacityUnits

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityUnitsConfiguration(")
        append("queryCapacityUnits=$queryCapacityUnits,")
        append("storageCapacityUnits=$storageCapacityUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = queryCapacityUnits ?: 0
        result = 31 * result + (storageCapacityUnits ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityUnitsConfiguration

        if (queryCapacityUnits != other.queryCapacityUnits) return false
        if (storageCapacityUnits != other.storageCapacityUnits) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The amount of extra query capacity for an index and [GetQuerySuggestions](https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html) capacity.
         *
         * A single extra capacity unit for an index provides 0.1 queries per second or approximately 8,000 queries per day.
         *
         * `GetQuerySuggestions` capacity is five times the provisioned query capacity for an index, or the base capacity of 2.5 calls per second, whichever is higher. For example, the base capacity for an index is 0.1 queries per second, and `GetQuerySuggestions` capacity has a base of 2.5 calls per second. If you add another 0.1 queries per second to total 0.2 queries per second for an index, the `GetQuerySuggestions` capacity is 2.5 calls per second (higher than five times 0.2 queries per second).
         */
        var queryCapacityUnits: kotlin.Int? = null
        /**
         * The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first.
         */
        var storageCapacityUnits: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration) : this() {
            this.queryCapacityUnits = x.queryCapacityUnits
            this.storageCapacityUnits = x.storageCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration = CapacityUnitsConfiguration(this)
    }
}
