// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Configuration information for indexing Confluence spaces.
 */
class ConfluenceSpaceConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether Amazon Kendra should index archived spaces.
     */
    val crawlArchivedSpaces: kotlin.Boolean = builder.crawlArchivedSpaces
    /**
     * Specifies whether Amazon Kendra should index personal spaces. Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
     */
    val crawlPersonalSpaces: kotlin.Boolean = builder.crawlPersonalSpaces
    /**
     * A list of space keys of Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the `ExcludeSpaces` and the `IncludeSpaces` list, the space is excluded.
     */
    val excludeSpaces: List<String>? = builder.excludeSpaces
    /**
     * A list of space keys for Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren't in the list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the `IncludeSpaces` and the `ExcludeSpaces` list, the space is excluded.
     */
    val includeSpaces: List<String>? = builder.includeSpaces
    /**
     * Maps attributes or field names of Confluence spaces to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Confluence fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Confluence data source field names must exist in your Confluence custom metadata.
     *
     * If you specify the `SpaceFieldMappings` parameter, you must specify at least one field mapping.
     */
    val spaceFieldMappings: List<ConfluenceSpaceToIndexFieldMapping>? = builder.spaceFieldMappings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceSpaceConfiguration(")
        append("crawlArchivedSpaces=$crawlArchivedSpaces,")
        append("crawlPersonalSpaces=$crawlPersonalSpaces,")
        append("excludeSpaces=$excludeSpaces,")
        append("includeSpaces=$includeSpaces,")
        append("spaceFieldMappings=$spaceFieldMappings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crawlArchivedSpaces.hashCode()
        result = 31 * result + (crawlPersonalSpaces.hashCode())
        result = 31 * result + (excludeSpaces?.hashCode() ?: 0)
        result = 31 * result + (includeSpaces?.hashCode() ?: 0)
        result = 31 * result + (spaceFieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceSpaceConfiguration

        if (crawlArchivedSpaces != other.crawlArchivedSpaces) return false
        if (crawlPersonalSpaces != other.crawlPersonalSpaces) return false
        if (excludeSpaces != other.excludeSpaces) return false
        if (includeSpaces != other.includeSpaces) return false
        if (spaceFieldMappings != other.spaceFieldMappings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether Amazon Kendra should index archived spaces.
         */
        var crawlArchivedSpaces: kotlin.Boolean = false
        /**
         * Specifies whether Amazon Kendra should index personal spaces. Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
         */
        var crawlPersonalSpaces: kotlin.Boolean = false
        /**
         * A list of space keys of Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the `ExcludeSpaces` and the `IncludeSpaces` list, the space is excluded.
         */
        var excludeSpaces: List<String>? = null
        /**
         * A list of space keys for Confluence spaces. If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren't in the list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the `IncludeSpaces` and the `ExcludeSpaces` list, the space is excluded.
         */
        var includeSpaces: List<String>? = null
        /**
         * Maps attributes or field names of Confluence spaces to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Confluence fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Confluence data source field names must exist in your Confluence custom metadata.
         *
         * If you specify the `SpaceFieldMappings` parameter, you must specify at least one field mapping.
         */
        var spaceFieldMappings: List<ConfluenceSpaceToIndexFieldMapping>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration) : this() {
            this.crawlArchivedSpaces = x.crawlArchivedSpaces
            this.crawlPersonalSpaces = x.crawlPersonalSpaces
            this.excludeSpaces = x.excludeSpaces
            this.includeSpaces = x.includeSpaces
            this.spaceFieldMappings = x.spaceFieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration = ConfluenceSpaceConfiguration(this)
    }
}
