// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class CreateIndexRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the index.
     */
    val description: kotlin.String? = builder.description
    /**
     * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed.
     *
     * The `Edition` parameter is optional. If you don't supply a value, the default is `ENTERPRISE_EDITION`.
     *
     * For more information on quota limits for enterprise and developer editions, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     */
    val edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = builder.edition
    /**
     * The name for the new index.
     */
    val name: kotlin.String? = builder.name
    /**
     * An Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The identifier of the KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
     */
    val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The user context policy.
     *
     * ## ATTRIBUTE_FILTER
     * All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of `_user_id` and `_group_ids` or you can provide user and group information in `UserContext`.
     *
     * ## USER_TOKEN
     * Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.
     */
    val userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = builder.userContextPolicy
    /**
     * Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html).
     */
    val userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = builder.userGroupResolutionConfiguration
    /**
     * The user token configuration.
     */
    val userTokenConfigurations: List<UserTokenConfiguration>? = builder.userTokenConfigurations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIndexRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("edition=$edition,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("tags=$tags,")
        append("userContextPolicy=$userContextPolicy,")
        append("userGroupResolutionConfiguration=$userGroupResolutionConfiguration,")
        append("userTokenConfigurations=$userTokenConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userContextPolicy?.hashCode() ?: 0)
        result = 31 * result + (userGroupResolutionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userTokenConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIndexRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (edition != other.edition) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (tags != other.tags) return false
        if (userContextPolicy != other.userContextPolicy) return false
        if (userGroupResolutionConfiguration != other.userGroupResolutionConfiguration) return false
        if (userTokenConfigurations != other.userTokenConfigurations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A token that you provide to identify the request to create an index. Multiple calls to the `CreateIndex` API with the same client token will create only one index.
         */
        var clientToken: kotlin.String? = null
        /**
         * A description for the index.
         */
        var description: kotlin.String? = null
        /**
         * The Amazon Kendra edition to use for the index. Choose `DEVELOPER_EDITION` for indexes intended for development, testing, or proof of concept. Use `ENTERPRISE_EDITION` for your production databases. Once you set the edition for an index, it can't be changed.
         *
         * The `Edition` parameter is optional. If you don't supply a value, the default is `ENTERPRISE_EDITION`.
         *
         * For more information on quota limits for enterprise and developer editions, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
         */
        var edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = null
        /**
         * The name for the new index.
         */
        var name: kotlin.String? = null
        /**
         * An Identity and Access Management (IAM) role that gives Amazon Kendra permissions to access your Amazon CloudWatch logs and metrics. This is also the role you use when you call the `BatchPutDocument` API to index documents from an Amazon S3 bucket.
         */
        var roleArn: kotlin.String? = null
        /**
         * The identifier of the KMS customer managed key (CMK) that's used to encrypt data indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
         */
        var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = null
        /**
         * A list of key-value pairs that identify the index. You can use the tags to identify and organize your resources and to control access to resources.
         */
        var tags: List<Tag>? = null
        /**
         * The user context policy.
         *
         * ## ATTRIBUTE_FILTER
         * All indexed content is searchable and displayable for all users. If you want to filter search results on user context, you can use the attribute filters of `_user_id` and `_group_ids` or you can provide user and group information in `UserContext`.
         *
         * ## USER_TOKEN
         * Enables token-based user access control to filter search results on user context. All documents with no access control and all documents accessible to the user will be searchable and displayable.
         */
        var userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = null
        /**
         * Enables fetching access levels of groups and users from an Amazon Web Services Single Sign On identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html).
         */
        var userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = null
        /**
         * The user token configuration.
         */
        var userTokenConfigurations: List<UserTokenConfiguration>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateIndexRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.edition = x.edition
            this.name = x.name
            this.roleArn = x.roleArn
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.tags = x.tags
            this.userContextPolicy = x.userContextPolicy
            this.userGroupResolutionConfiguration = x.userGroupResolutionConfiguration
            this.userTokenConfigurations = x.userTokenConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateIndexRequest = CreateIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration] inside the given [block]
         */
        fun userGroupResolutionConfiguration(block: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.Builder.() -> kotlin.Unit) {
            this.userGroupResolutionConfiguration = aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.invoke(block)
        }
    }
}
