// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class CreateQuerySuggestionsBlockListRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a query suggestions block list.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A user-friendly description for the block list.
     *
     * For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the index you want to create a query suggestions block list for.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * A user friendly name for the block list.
     *
     * For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.
     */
    val name: kotlin.String? = builder.name
    /**
     * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.
     *
     * You need permissions to the role ARN (Amazon Web Services Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The S3 path to your block list text file in your S3 bucket.
     *
     * Each block word or phrase should be on a separate line in a text file.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     */
    val sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sourceS3Path
    /**
     * A tag that you can assign to a block list that categorizes the block list.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQuerySuggestionsBlockListRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sourceS3Path=$sourceS3Path,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Path?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQuerySuggestionsBlockListRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sourceS3Path != other.sourceS3Path) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A token that you provide to identify the request to create a query suggestions block list.
         */
        var clientToken: kotlin.String? = null
        /**
         * A user-friendly description for the block list.
         *
         * For example, the description "List of all offensive words that can appear in user queries and need to be blocked from suggestions."
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the index you want to create a query suggestions block list for.
         */
        var indexId: kotlin.String? = null
        /**
         * A user friendly name for the block list.
         *
         * For example, the block list named 'offensive-words' includes all offensive words that could appear in user queries and need to be blocked from suggestions.
         */
        var name: kotlin.String? = null
        /**
         * The IAM (Identity and Access Management) role used by Amazon Kendra to access the block list text file in your S3 bucket.
         *
         * You need permissions to the role ARN (Amazon Web Services Resource Name). The role needs S3 read permissions to your file in S3 and needs to give STS (Security Token Service) assume role permissions to Amazon Kendra.
         */
        var roleArn: kotlin.String? = null
        /**
         * The S3 path to your block list text file in your S3 bucket.
         *
         * Each block word or phrase should be on a separate line in a text file.
         *
         * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
         */
        var sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * A tag that you can assign to a block list that categorizes the block list.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.indexId = x.indexId
            this.name = x.name
            this.roleArn = x.roleArn
            this.sourceS3Path = x.sourceS3Path
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest = CreateQuerySuggestionsBlockListRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        fun sourceS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sourceS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }
    }
}
