// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeDataSourceResponse private constructor(builder: Builder) {
    /**
     * Describes how the data source is configured. The specific information in the description depends on the data source provider.
     */
    val configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = builder.configuration
    /**
     * The Unix timestamp of when the data source was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Configuration information for altering document metadata and content during the document ingestion process when you describe a data source.
     *
     * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
     */
    val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * The description of the data source.
     */
    val description: kotlin.String? = builder.description
    /**
     * When the `Status` field value is `FAILED`, the `ErrorMessage` field contains a description of the error that caused the data source to fail.
     */
    val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The identifier of the data source.
     */
    val id: kotlin.String? = builder.id
    /**
     * The identifier of the index that contains the data source.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The code for a language. This shows a supported language for all documents in the data source. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    val languageCode: kotlin.String? = builder.languageCode
    /**
     * The name that you gave the data source when it was created.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The schedule for Amazon Kendra to update the index.
     */
    val schedule: kotlin.String? = builder.schedule
    /**
     * The current status of the data source. When the status is `ACTIVE` the data source is ready to use. When the status is `FAILED`, the `ErrorMessage` field contains the reason that the data source failed.
     */
    val status: aws.sdk.kotlin.services.kendra.model.DataSourceStatus? = builder.status
    /**
     * The type of the data source.
     */
    val type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = builder.type
    /**
     * The Unix timestamp of when the data source was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DescribeDataSourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDataSourceResponse(")
        append("configuration=$configuration,")
        append("createdAt=$createdAt,")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("description=$description,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("indexId=$indexId,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("status=$status,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customDocumentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDataSourceResponse

        if (configuration != other.configuration) return false
        if (createdAt != other.createdAt) return false
        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (description != other.description) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (indexId != other.indexId) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DescribeDataSourceResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes how the data source is configured. The specific information in the description depends on the data source provider.
         */
        var configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = null
        /**
         * The Unix timestamp of when the data source was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration information for altering document metadata and content during the document ingestion process when you describe a data source.
         *
         * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
         */
        var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * The description of the data source.
         */
        var description: kotlin.String? = null
        /**
         * When the `Status` field value is `FAILED`, the `ErrorMessage` field contains a description of the error that caused the data source to fail.
         */
        var errorMessage: kotlin.String? = null
        /**
         * The identifier of the data source.
         */
        var id: kotlin.String? = null
        /**
         * The identifier of the index that contains the data source.
         */
        var indexId: kotlin.String? = null
        /**
         * The code for a language. This shows a supported language for all documents in the data source. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
         */
        var languageCode: kotlin.String? = null
        /**
         * The name that you gave the data source when it was created.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role that enables the data source to access its resources.
         */
        var roleArn: kotlin.String? = null
        /**
         * The schedule for Amazon Kendra to update the index.
         */
        var schedule: kotlin.String? = null
        /**
         * The current status of the data source. When the status is `ACTIVE` the data source is ready to use. When the status is `FAILED`, the `ErrorMessage` field contains the reason that the data source failed.
         */
        var status: aws.sdk.kotlin.services.kendra.model.DataSourceStatus? = null
        /**
         * The type of the data source.
         */
        var type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = null
        /**
         * The Unix timestamp of when the data source was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DescribeDataSourceResponse) : this() {
            this.configuration = x.configuration
            this.createdAt = x.createdAt
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.description = x.description
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.indexId = x.indexId
            this.languageCode = x.languageCode
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.status = x.status
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DescribeDataSourceResponse = DescribeDataSourceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }
    }
}
