// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. You use this with [DocumentAttributeTarget to apply the condition](https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeTarget.html).
 *
 * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
 *
 * Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using `DocumentAttributeTarget`. Amazon Kendra then will map your newly created metadata field to your index field.
 */
class DocumentAttributeCondition private constructor(builder: Builder) {
    /**
     * The identifier of the document attribute used for the condition.
     *
     * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
     *
     * Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
     */
    val conditionDocumentAttributeKey: kotlin.String? = builder.conditionDocumentAttributeKey
    /**
     * The value used by the operator.
     *
     * For example, you can specify the value 'financial' for strings in the 'Source_URI' field that partially match or contain this value.
     */
    val conditionOnValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = builder.conditionOnValue
    /**
     * The condition operator.
     *
     * For example, you can use 'Contains' to partially match a string.
     */
    val operator: aws.sdk.kotlin.services.kendra.model.ConditionOperator? = builder.operator

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeCondition(")
        append("conditionDocumentAttributeKey=$conditionDocumentAttributeKey,")
        append("conditionOnValue=$conditionOnValue,")
        append("operator=$operator)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conditionDocumentAttributeKey?.hashCode() ?: 0
        result = 31 * result + (conditionOnValue?.hashCode() ?: 0)
        result = 31 * result + (operator?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeCondition

        if (conditionDocumentAttributeKey != other.conditionDocumentAttributeKey) return false
        if (conditionOnValue != other.conditionOnValue) return false
        if (operator != other.operator) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the document attribute used for the condition.
         *
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         *
         * Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
         */
        var conditionDocumentAttributeKey: kotlin.String? = null
        /**
         * The value used by the operator.
         *
         * For example, you can specify the value 'financial' for strings in the 'Source_URI' field that partially match or contain this value.
         */
        var conditionOnValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = null
        /**
         * The condition operator.
         *
         * For example, you can use 'Contains' to partially match a string.
         */
        var operator: aws.sdk.kotlin.services.kendra.model.ConditionOperator? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition) : this() {
            this.conditionDocumentAttributeKey = x.conditionDocumentAttributeKey
            this.conditionOnValue = x.conditionOnValue
            this.operator = x.operator
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition = DocumentAttributeCondition(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue] inside the given [block]
         */
        fun conditionOnValue(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.Builder.() -> kotlin.Unit) {
            this.conditionOnValue = aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.invoke(block)
        }
    }
}
