// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Information about a document attribute. You can use document attributes as facets.
 *
 * For example, the document attribute or facet "Department" includes the values "HR", "Engineering", and "Accounting". You can display these values in the search results so that documents can be searched by department.
 *
 * You can display up to 10 facet values per facet for a query. If you want to increase this limit, contact [Support](http://aws.amazon.com/contact-us/).
 */
class Facet private constructor(builder: Builder) {
    /**
     * The unique key for the document attribute.
     */
    val documentAttributeKey: kotlin.String? = builder.documentAttributeKey
    /**
     * An array of document attributes that are nested facets within a facet.
     *
     * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. This helps your users further narrow their search.
     *
     * You can only have one nested facet within a facet. If you want to increase this limit, contact [Support](http://aws.amazon.com/contact-us/).
     */
    val facets: List<Facet>? = builder.facets
    /**
     * Maximum number of facet values per facet. The default is 10. You can use this to limit the number of facet values to less than 10. If you want to increase the default, contact [Support](http://aws.amazon.com/contact-us/).
     */
    val maxResults: kotlin.Int = builder.maxResults

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Facet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Facet(")
        append("documentAttributeKey=$documentAttributeKey,")
        append("facets=$facets,")
        append("maxResults=$maxResults)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentAttributeKey?.hashCode() ?: 0
        result = 31 * result + (facets?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Facet

        if (documentAttributeKey != other.documentAttributeKey) return false
        if (facets != other.facets) return false
        if (maxResults != other.maxResults) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Facet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique key for the document attribute.
         */
        var documentAttributeKey: kotlin.String? = null
        /**
         * An array of document attributes that are nested facets within a facet.
         *
         * For example, the document attribute or facet "Department" includes a value called "Engineering". In addition, the document attribute or facet "SubDepartment" includes the values "Frontend" and "Backend" for documents assigned to "Engineering". You can display nested facets in the search results so that documents can be searched not only by department but also by a sub department within a department. This helps your users further narrow their search.
         *
         * You can only have one nested facet within a facet. If you want to increase this limit, contact [Support](http://aws.amazon.com/contact-us/).
         */
        var facets: List<Facet>? = null
        /**
         * Maximum number of facet values per facet. The default is 10. You can use this to limit the number of facet values to less than 10. If you want to increase the default, contact [Support](http://aws.amazon.com/contact-us/).
         */
        var maxResults: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Facet) : this() {
            this.documentAttributeKey = x.documentAttributeKey
            this.facets = x.facets
            this.maxResults = x.maxResults
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Facet = Facet(this)
    }
}
