// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Google Drive as your data source.
 */
class GoogleDriveConfiguration private constructor(builder: Builder) {
    /**
     * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
     *
     * For a list of MIME types, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
     */
    val excludeMimeTypes: List<String>? = builder.excludeMimeTypes
    /**
     * A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared drive are excluded.
     */
    val excludeSharedDrives: List<String>? = builder.excludeSharedDrives
    /**
     * A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.
     */
    val excludeUserAccounts: List<String>? = builder.excludeUserAccounts
    /**
     * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and users' My Drives. Items that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Google Drive fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Google Drive data source field names must exist in your Google Drive custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain items in your Google Drive, including shared drives and users' My Drives. Items that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect to Google Drive. For more information, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
     */
    val secretArn: kotlin.String? = builder.secretArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GoogleDriveConfiguration(")
        append("excludeMimeTypes=$excludeMimeTypes,")
        append("excludeSharedDrives=$excludeSharedDrives,")
        append("excludeUserAccounts=$excludeUserAccounts,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("secretArn=$secretArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludeMimeTypes?.hashCode() ?: 0
        result = 31 * result + (excludeSharedDrives?.hashCode() ?: 0)
        result = 31 * result + (excludeUserAccounts?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GoogleDriveConfiguration

        if (excludeMimeTypes != other.excludeMimeTypes) return false
        if (excludeSharedDrives != other.excludeSharedDrives) return false
        if (excludeUserAccounts != other.excludeUserAccounts) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (secretArn != other.secretArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
         *
         * For a list of MIME types, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
         */
        var excludeMimeTypes: List<String>? = null
        /**
         * A list of identifiers or shared drives to exclude from the index. All files and folders stored on the shared drive are excluded.
         */
        var excludeSharedDrives: List<String>? = null
        /**
         * A list of email addresses of the users. Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.
         */
        var excludeUserAccounts: List<String>? = null
        /**
         * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and users' My Drives. Items that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * Maps Google Drive data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Google Drive fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Google Drive data source field names must exist in your Google Drive custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain items in your Google Drive, including shared drives and users' My Drives. Items that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the credentials required to connect to Google Drive. For more information, see [Using a Google Workspace Drive data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
         */
        var secretArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration) : this() {
            this.excludeMimeTypes = x.excludeMimeTypes
            this.excludeSharedDrives = x.excludeSharedDrives
            this.excludeUserAccounts = x.excludeUserAccounts
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.secretArn = x.secretArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.GoogleDriveConfiguration = GoogleDriveConfiguration(this)
    }
}
